/*
 * Decompiled with CFR 0.152.
 */
package nl.komponents.kovenant;

import java.util.ArrayList;
import java.util.List;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import nl.komponents.kovenant.BlockingPollStrategyFactory;
import nl.komponents.kovenant.BlockingSleepPollStrategyFactory;
import nl.komponents.kovenant.BusyPollStrategyFactory;
import nl.komponents.kovenant.ChainPollStrategyFactory;
import nl.komponents.kovenant.PollStrategy;
import nl.komponents.kovenant.PollStrategyBuilder;
import nl.komponents.kovenant.PollStrategyFactory;
import nl.komponents.kovenant.Pollable;
import nl.komponents.kovenant.SleepingPollStrategyFactory;
import nl.komponents.kovenant.YieldingPollStrategyFactory;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={";\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\t\u0003\u0015\tA1A\u0003\u0002\u0011\u0011)\u0001!B\u0001\t\n\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\u0015A\u0002A\r\u00021\u0003\t+!U\u0002\u0002\u0011\u0005)C\u0001B\u0006\t\t5\t\u0001tA\u0013\r\t-AI!D\u0001\u0019\be\u0019\u0001\"B\u0007\u00021\u0017I2\u0001\u0003\u0004\u000e\u0003a5Qe\u0005\u0005\b\u001b\u001dIQ!\u0003\u0003\n\u0005%\t\u0001t\u0001\r\u00041\u001fI\u0012\u0002\u0003\u0005\u000e\u000f%)\u0011\u0002B\u0005\u0003\u0013\u0005A:\u0001G\u0002\u0019\u0012\u0015\"B!\u0001\u0005\n\u001b\u001dIQ!\u0003\u0003\n\u0005%\t\u0001t\u0001\r\u00041\u001fI\u0012\u0002\u0003\u0005\u000e\u000f%)\u0011\u0002B\u0005\u0003\u0013\u0005A:\u0001G\u0002\u0019\u0012\u0015BAa\u0003E\n\u001b\u0005A:!G\u0002\t\u000b5\t\u00014B\u0013\u0004\u0011)i\u0011\u0001g\u0002&\u0019\u0011Y\u0001RC\u0007\u00021\u000fI2\u0001C\u0003\u000e\u0003a-\u0011d\u0001\u0005\u0007\u001b\u0005Aj!\n\u0005\u0005\u0017!YQ\"\u0001M\u00043\rAQ!D\u0001\u0019\f%\u0002B!\u0011\u0005\t\u00045Q\u0011\u0002C\u0005\b\u0013\u0015IA!\u0003\u0002\n\u0003a\u001d\u0001d\u0001M\u00031\t\t6!A\u0003\u0001"}, strings={"Lnl/komponents/kovenant/ConcretePollStrategyBuilder;", "Lnl/komponents/kovenant/PollStrategyBuilder;", "()V", "factories", "Ljava/util/ArrayList;", "Lnl/komponents/kovenant/PollStrategyFactory;", "Lkotlin/Function0;", "", "blocking", "blockingSleep", "numberOfPolls", "", "sleepTimeInMs", "", "build", "Lnl/komponents/kovenant/PollStrategy;", "pollable", "Lnl/komponents/kovenant/Pollable;", "buildDefaultStrategy", "busy", "clear", "sleeping", "yielding"}, moduleName="kovenant-core-compileKotlin")
public final class ConcretePollStrategyBuilder
implements PollStrategyBuilder {
    private final ArrayList<PollStrategyFactory<Function0<Unit>>> factories = new ArrayList();

    public final void clear() {
        this.factories.clear();
    }

    @Override
    public void yielding(int numberOfPolls) {
        this.factories.add(new YieldingPollStrategyFactory(numberOfPolls));
    }

    @Override
    public void sleeping(int numberOfPolls, long sleepTimeInMs) {
        this.factories.add(new SleepingPollStrategyFactory(numberOfPolls, sleepTimeInMs));
    }

    @Override
    public void busy(int numberOfPolls) {
        this.factories.add(new BusyPollStrategyFactory(numberOfPolls));
    }

    @Override
    public void blocking() {
        this.factories.add(new BlockingPollStrategyFactory());
    }

    @Override
    public void blockingSleep(int numberOfPolls, long sleepTimeInMs) {
        this.factories.add(new BlockingSleepPollStrategyFactory(numberOfPolls, sleepTimeInMs));
    }

    private final PollStrategy<Function0<Unit>> buildDefaultStrategy(Pollable<Function0<Unit>> pollable) {
        List defaultFactories = CollectionsKt.listOf((Object[])new PollStrategyFactory[]{new YieldingPollStrategyFactory(0, 1, null), new SleepingPollStrategyFactory(0, 0L, 3, null)});
        return new ChainPollStrategyFactory<Function0<Unit>>(defaultFactories).build(pollable);
    }

    @NotNull
    public final PollStrategy<Function0<Unit>> build(@NotNull Pollable<Function0<Unit>> pollable) {
        Intrinsics.checkParameterIsNotNull(pollable, (String)"pollable");
        return this.factories.isEmpty() ? this.buildDefaultStrategy(pollable) : new ChainPollStrategyFactory<Function0<Unit>>((List)this.factories).build(pollable);
    }
}

