/*
 * Decompiled with CFR 0.152.
 */
package nl.komponents.kovenant;

import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import nl.komponents.kovenant.WorkQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u000f\u0010\t\u001a\u0004\u0018\u00018\u0000H\u0002\u00a2\u0006\u0002\u0010\nJ\u0017\u0010\t\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010\rJ\u0015\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0011J\u001f\u0010\u0012\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\u0014J\u0015\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0011J\u000f\u0010\u0016\u001a\u0004\u0018\u00018\u0000H&\u00a2\u0006\u0002\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lnl/komponents/kovenant/BlockingSupportWorkQueue;", "V", "", "Lnl/komponents/kovenant/WorkQueue;", "()V", "mutex", "Ljava/lang/Object;", "waitingThreads", "Ljava/util/concurrent/atomic/AtomicInteger;", "blockingPoll", "()Ljava/lang/Object;", "timeoutMs", "", "(J)Ljava/lang/Object;", "offer", "", "elem", "(Ljava/lang/Object;)Z", "poll", "block", "(ZJ)Ljava/lang/Object;", "tryOffer", "tryPoll", "kovenant-core-compileKotlin"})
@KotlinClass(version={1, 1, 0}, data={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u000f\u0010\t\u001a\u0004\u0018\u00018\u0000H\u0002\u00a2\u0006\u0002\u0010\nJ\u0017\u0010\t\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010\rJ\u0015\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0011J\u001f\u0010\u0012\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\u0014J\u0015\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0011J\u000f\u0010\u0016\u001a\u0004\u0018\u00018\u0000H&\u00a2\u0006\u0002\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, strings={"Lnl/komponents/kovenant/BlockingSupportWorkQueue;", "V", "", "Lnl/komponents/kovenant/WorkQueue;", "()V", "mutex", "Ljava/lang/Object;", "waitingThreads", "Ljava/util/concurrent/atomic/AtomicInteger;", "blockingPoll", "()Ljava/lang/Object;", "timeoutMs", "", "(J)Ljava/lang/Object;", "offer", "", "elem", "(Ljava/lang/Object;)Z", "poll", "block", "(ZJ)Ljava/lang/Object;", "tryOffer", "tryPoll", "kovenant-core-compileKotlin"})
public abstract class BlockingSupportWorkQueue<V>
implements WorkQueue<V> {
    private final AtomicInteger waitingThreads = new AtomicInteger(0);
    private final Object mutex = new Object();

    @Nullable
    public abstract V tryPoll();

    public abstract boolean tryOffer(@NotNull V var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(@NotNull V elem) {
        Intrinsics.checkParameterIsNotNull(elem, (String)"elem");
        boolean added = this.tryOffer(elem);
        if (added && this.waitingThreads.get() > 0) {
            Object lock$iv = this.mutex;
            synchronized (lock$iv) {
                this.mutex.notifyAll();
                Unit unit = Unit.INSTANCE;
            }
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public V poll(boolean block, long timeoutMs) {
        if (!block) {
            return this.tryPoll();
        }
        V elem = this.tryPoll();
        if (elem != null) {
            return elem;
        }
        this.waitingThreads.incrementAndGet();
        try {
            V v = timeoutMs > -1L ? this.blockingPoll(timeoutMs) : this.blockingPoll();
            return v;
        }
        finally {
            this.waitingThreads.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final V blockingPoll() {
        Object lock$iv = this.mutex;
        synchronized (lock$iv) {
            V v;
            while (true) {
                V retry;
                if ((retry = this.tryPoll()) == null) break block5;
                v = retry;
                break;
            }
            {
                block5: {
                    return v;
                }
                this.mutex.wait();
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final V blockingPoll(long timeoutMs) {
        void lock$iv;
        long deadline = System.currentTimeMillis() + timeoutMs;
        Object object = this.mutex;
        synchronized (lock$iv) {
            V v;
            while (true) {
                V retry;
                if ((retry = this.tryPoll()) == null && System.currentTimeMillis() < deadline) break block5;
                v = retry;
                break;
            }
            {
                block5: {
                    return v;
                }
                this.mutex.wait(timeoutMs);
                continue;
            }
        }
    }

    @Override
    public boolean isNotEmpty() {
        return WorkQueue.DefaultImpls.isNotEmpty(this);
    }

    @Override
    public boolean isEmpty() {
        return WorkQueue.DefaultImpls.isEmpty(this);
    }
}

