package nl.lockhead.lpf.events;

public interface Cancellable {

    /**
     * @return whether the event has been cancelled.
     */
    default boolean isCancelled() {
        return false;
    }

    /**
     * Cancelling an event will prevent the action, with which this event is associated, to further run.
     * @param cancelled whether or not this event should be cancelled.
     */
    void setCancelled(boolean cancelled);
}
