package nl.lockhead.lpf.plugins.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * Provides mandatory information about your plugin.
 *
 * @author lkhd
 */
@Documented
@Retention(RUNTIME)
@Target(TYPE)
public @interface PluginInfo {

    /**
     * The name of the plugin. <br>
     * Must be alphanumeric. Spaces are <u>not</u> allowed.
     *
     * @return the plugin name
     */
    String name();

    /**
     * The name of the plugin author. Presumably you. <br>
     * Must be alphanumeric. Spaces are <u>not</u> allowed.
     *
     * @return the plugin author
     */
    String author();

    /**
     * Must be in format "MAJOR.MINOR.PATCH" <br>
     * Examples: "1.2.13", "1.0.0", "0.0.1"
     *
     * @return the plugin's semantic version
     */
    String version();
}
