package nl.lockhead.lpf.plugins.loaders;

import nl.lockhead.lpf.plugins.plugin.PluginContainer;

import java.net.URL;
import java.util.List;
import java.util.Set;

public interface IPluginLoader {

    /**
     * @return the amount of plugins loaded
     */
    Set<PluginContainer> loadPlugins();

    /**
     * @return whether the plugin loader is currently running its tasks
     */
    boolean isRunning();

    /**
     * @return a list of URLs of Jar files the Classloader needs
     */
    List<URL> getClassloaderUrls();
}
