package nl.lockhead.lpf.plugins.plugin;

import java.util.regex.Pattern;

public class Version {

    private static final Pattern VERSION = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,6}");
    private final Short major, minor, patch;

    public Version(Short major, Short minor, Short patch) {
        this.major = major == null ? (Short.valueOf((short) 0)) : major;
        this.minor = minor == null ? (Short.valueOf((short) 0)) : minor;
        this.patch = patch == null ? (Short.valueOf((short) 1)) : patch;
    }

    public Version(Integer major, Integer minor, Integer patch) {
        this.major = (short) (major == null ? (Short.valueOf((short) 0)) : major);
        this.minor = (short) (minor == null ? (Short.valueOf((short) 0)) : minor);
        this.patch = (short) (patch == null ? (Short.valueOf((short) 1)) : patch);
    }

    //for convenience
    public static Version getVersion(String versionString) {
        return parseVersion(versionString);
    }

    /**
     * Parse version from string.
     *
     * @param versionString the string to parse. Expects MAJOR.MINOR.PATCH, e.g. 1.0.2, 4.3.72, and so on.
     * @return the generated Version
     */
    public static Version parseVersion(String versionString) {
        versionString = versionString.replaceAll("[^\\d.]", "");
        if (!VERSION.matcher(versionString).matches())
            throw new IllegalArgumentException("version string must match MAJOR.MINOR.PATCH");
        String[] s = versionString.split("\\.");
        return new Version(Short.parseShort(s[0]), Short.parseShort(s[1]), Short.parseShort(s[2]));
    }

    public final short getMajor() {
        return major;
    }

    public final short getMinor() {
        return minor;
    }

    public final short getPatch() {
        return patch;
    }

    @Override
    public String toString() {
        return major + "." + minor + "." + patch;
    }

    //for convenience
    public String getAsString() {
        return toString();
    }
}
