package nl.lockhead.lpf.tools;

import java.io.*;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.*;

import static nl.lockhead.lpf.tools.Matching.MATCH_NON;

@SuppressWarnings({"unused", "ResultOfMethodCallIgnored"})
public final class FileManager {

    public static String lastFile = "";
    private static List<String> EXTENSIONS = Arrays.asList(".txt", ".log", ".json", ".xml", ".lh", ".bat");

    private FileManager() throws IllegalAccessException {
        throw new IllegalAccessException("Yeah nah yeah nah nah yeah");
    }

    public static String getWorkingDirectory() {
        try {
            if (MATCH_NON.matcher(System.getProperty("os.name").toLowerCase()).replaceAll("").contains("windows"))
                return new File(FileManager.class.getProtectionDomain().getCodeSource()
                        .getLocation().toURI().getPath().substring(1)).getParentFile().getAbsolutePath();
            return new File(FileManager.class.getProtectionDomain().getCodeSource()
                    .getLocation().toURI().getPath()).getParentFile().getAbsolutePath();
        } catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static File getThisFile() {
        try {
            if (MATCH_NON.matcher(System.getProperty("os.name").toLowerCase()).replaceAll("").contains("windows"))
                return new File(FileManager.class.getProtectionDomain().getCodeSource()
                        .getLocation().toURI().getPath().substring(1));
            return new File(FileManager.class.getProtectionDomain().getCodeSource()
                    .getLocation().toURI().getPath());
        } catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void deleteDirectory(File f) {
        if (!f.isDirectory())
            return;
        for (File d : Objects.requireNonNull(f.listFiles())) {
            if (d.isFile())
                d.delete();
        }
    }

    public static void deleteDirectoryAndSubs(File f) {
        for (File d : Objects.requireNonNull(f.listFiles())) {
            if (d.isFile())
                d.delete();
            else if (d.isDirectory())
                deleteDirectoryAndSubs(d);
        }
    }

    public static String[] readFile(String file) {
        try (InputStream in = FileManager.class.getResourceAsStream(file.startsWith("/") ? file : ("/" + file));
             BufferedReader reader = new BufferedReader(new InputStreamReader(in))) {
            List<String> result = new ArrayList<>();
            String line;
            while ((line = reader.readLine()) != null) {
                result.add(line);
            }
            return result.toArray(new String[0]);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String readFile(URL file) {
        try {
            StringBuilder result = new StringBuilder();

            try (Scanner scanner = new Scanner(new File(file.getFile().replace("%20", " ")))) {

                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine();
                    result.append(line).append("\n");
                }

                return result.toString();
            } catch (Exception ignored) {
//				e.printStackTrace();
            }

        } catch (Exception ignored) {
//			e.printStackTrace();
        }
        return null;
    }

    public static String readFile(File file) {
        String contents = "";
        try {
            byte[] byt = Files.readAllBytes(file.toPath());
            return new String(byt, Charset.defaultCharset());
        } catch (IOException e) {
            e.printStackTrace();
        }
        return contents;
    }

    public static void writeToFile(File file, String contents, boolean clearBeforeWrite) {
        try {
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(file))) {
                if (clearBeforeWrite)
                    writer.write("");
                writer.append(contents);
            }
        } catch (Exception e) {
            System.err.println("====================DEBUG INFO=====================");
            System.err.println("file: " + file);
            System.err.println("file path: " + file.getAbsolutePath());
            e.printStackTrace();
        }
    }

    public static void move(File from, File to) {
        try {
            Files.move(from.toPath(), to.toPath(), StandardCopyOption.REPLACE_EXISTING);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void copy(File file, File to) {
        try {
            Files.copy(file.toPath(), to.toPath(), StandardCopyOption.REPLACE_EXISTING);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void delete(File file) {
        try {
            Files.deleteIfExists(file.toPath());
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void rename(File file, File to) {
        file.renameTo(to);
    }

    //	public static String readFil32
//	public static String readFile(File file, boolean encode) {
//		String contents = "";
//		try {
//			byte[] byt = Files.readAllBytes(file.toPath());
//			if (encode) {
//				return Base64.encode(byt);
//			}
//			return new String(byt, Charset.defaultCharset());
//		} catch (IOException e) {
//			e.printStackTrace();
//		}
//		return contents;
//	}
//
//	public static void writeToFile(File file, String contents, boolean clearBeforeWrite) {
//		try {
//			if (!file.exists()) {
//				file.getParentFile().mkdirs();
//				file.createNewFile();
//			}
//			boolean decode = true;
//			for (String ex : extensions) {
//				if (file.getName().endsWith(ex)) {
//					decode = false;
//					break;
//				}
//			}
//			if (decode) {
//				try (FileOutputStream fos = new FileOutputStream(file)) {
//					fos.write(Base64.decode(contents));
//				}
//				return;
//			}
//            try (BufferedWriter writer = new BufferedWriter(new FileWriter(file))) {
//	            if (clearBeforeWrite)
//	            	writer.write("");
//	            writer.append(contents);
//            }
//		}
//		catch (Exception e) {
//			e.printStackTrace();
//		}
//	}
    public static void download(URL from, File file) throws IOException {
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        URLConnection uc = from.openConnection();
        uc.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)");
        try (ReadableByteChannel rbc = Channels.newChannel(uc.getInputStream());
             FileOutputStream fos = new FileOutputStream(file)) {
            fos.getChannel().transferFrom(rbc, 0, Long.MAX_VALUE);
        }
    }
}
