/*
 * Decompiled with CFR 0.152.
 */
package nl.lockhead.lpf.plugins;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import nl.lockhead.lpf.events.LPFEvent;
import nl.lockhead.lpf.exceptions.InvalidLPFEventException;
import nl.lockhead.lpf.plugins.annotations.PluginEvent;
import nl.lockhead.lpf.plugins.loaders.IPluginLoader;
import nl.lockhead.lpf.plugins.plugin.Plugin;
import nl.lockhead.lpf.plugins.plugin.PluginContainer;
import org.jetbrains.annotations.NotNull;

public class PluginManager {
    private static PluginManager instance;
    private final ConcurrentLinkedQueue<PluginContainer> plugins;
    private final Map<PluginContainer, HashMap<Class<? extends LPFEvent>, Method>> registeredEvents = new HashMap<PluginContainer, HashMap<Class<? extends LPFEvent>, Method>>();

    private PluginManager() {
        this.plugins = new ConcurrentLinkedQueue();
    }

    public static PluginManager get() {
        return instance == null ? (instance = new PluginManager()) : instance;
    }

    @NotNull
    public static List<Method> getMethodsAnnotatedWith(Class<?> type, Class<? extends Annotation> annotation) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Class<?> klass = type; klass != Object.class; klass = klass.getSuperclass()) {
            ArrayList<Method> allMethods = new ArrayList<Method>(Arrays.asList(klass.getDeclaredMethods()));
            allMethods.stream().filter(method -> method.isAnnotationPresent(annotation)).forEach(methods::add);
        }
        return methods;
    }

    public ConcurrentLinkedQueue<PluginContainer> getPlugins() {
        return this.plugins;
    }

    public void registerEvents(@NotNull Plugin plugin) {
        for (PluginContainer pc : this.plugins) {
            if (plugin.getId() != pc.getPlugin().getId()) continue;
            HashMap methods = new HashMap();
            for (Method method : PluginManager.getMethodsAnnotatedWith(plugin.getClass(), PluginEvent.class)) {
                try {
                    Parameter[] p = method.getParameters();
                    if (p.length != 1) {
                        StringBuilder s = new StringBuilder();
                        for (Parameter par : p) {
                            s.append(par.getType().getSimpleName()).append(" ").append(par.getName()).append(", ");
                        }
                        if (s.length() > 0) {
                            s = new StringBuilder(s.toString().trim().substring(0, s.length() - 2));
                        }
                        throw new InvalidLPFEventException(String.format("%s(%s) should only use one parameter directly extending superclass LPFEvent", method.getName(), s));
                    }
                    if (p[0].getType().getSuperclass() != LPFEvent.class) {
                        throw new InvalidLPFEventException(String.format("The parameter in %s(%s %s) should only directly extend superclass LPFEvent", method.getName(), p[0].getType().getSimpleName(), p[0].getName()));
                    }
                    methods.put(p[0].getType(), method);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (methods.size() <= 0) break;
            this.registeredEvents.put(pc, methods);
            break;
        }
    }

    public void loadPlugins(@NotNull IPluginLoader loader) {
        this.plugins.addAll(loader.loadPlugins());
    }

    public void enablePlugins() {
        for (PluginContainer pc : this.plugins) {
            try {
                pc.enablePlugin();
            }
            catch (UnsupportedOperationException e) {
                e.printStackTrace();
            }
        }
    }

    public void disablePlugins() {
        for (PluginContainer pc : this.plugins) {
            try {
                pc.disablePlugin();
            }
            catch (UnsupportedOperationException e) {
                e.printStackTrace();
            }
        }
    }

    public void unloadPlugins() {
        for (PluginContainer pc : this.plugins) {
            try {
                pc.unloadPlugin();
            }
            catch (UnsupportedOperationException e) {
                e.printStackTrace();
            }
        }
        this.plugins.clear();
    }

    public final Map<PluginContainer, HashMap<Class<? extends LPFEvent>, Method>> getRegisteredEvents() {
        return this.registeredEvents;
    }
}

