/*
 * Decompiled with CFR 0.152.
 */
package nl.lockhead.lpf.plugins.loaders.impl;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import nl.lockhead.lpf.exceptions.InvalidPluginException;
import nl.lockhead.lpf.plugins.loaders.IPluginLoader;
import nl.lockhead.lpf.plugins.plugin.Plugin;
import nl.lockhead.lpf.plugins.plugin.PluginContainer;

public class FilePluginLoader
implements IPluginLoader {
    private final File directory;
    private final boolean subDirs;
    private boolean running;
    private List<URL> classloaderUrls;

    public FilePluginLoader(List<URL> classloaderUrls, File directory, boolean checkSubDirectories) throws IllegalArgumentException {
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("\"" + directory.getAbsolutePath() + "\" is not a directory.");
        }
        this.directory = directory;
        this.subDirs = checkSubDirectories;
        this.classloaderUrls = classloaderUrls;
    }

    @Override
    public Set<PluginContainer> loadPlugins() {
        return this.loadPlugins(this.directory, this.subDirs);
    }

    public Set<PluginContainer> loadPlugins(File directory, boolean checkSubDirectories) {
        if (!this.running) {
            this.running = true;
            try {
                HashSet<PluginContainer> loaded = new HashSet<PluginContainer>();
                this.search(plugins -> {
                    for (File f : plugins) {
                        try {
                            PluginContainer pc = new PluginContainer(this.loadPlugin(f));
                            loaded.add(pc);
                        }
                        catch (IOException | InvalidPluginException e) {
                            e.printStackTrace();
                        }
                    }
                    this.running = false;
                }, directory, checkSubDirectories);
                return loaded;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.err.print("A plugin loader instance is already running!");
        }
        return Collections.emptySet();
    }

    /*
     * Exception decompiling
     */
    public Plugin loadPlugin(File file) throws InvalidPluginException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void search(Callback callback, File directory, boolean subDirs) throws IOException {
        ArrayList<File> pluginsFound = new ArrayList<File>();
        List f = (subDirs ? Files.walk(directory.toPath(), new FileVisitOption[0]) : Files.list(directory.toPath())).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toFile).collect(Collectors.toList());
        f.stream().filter(file -> file.getName().endsWith(".jar")).forEach(pluginsFound::add);
        callback.onFinish(pluginsFound);
    }

    public final File getDirectory() {
        return this.directory;
    }

    public final boolean isSubDirs() {
        return this.subDirs;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public List<URL> getClassloaderUrls() {
        return this.classloaderUrls;
    }

    public static interface Callback {
        public void onFinish(List<File> var1);
    }
}

