/*
 * Decompiled with CFR 0.152.
 */
package nl.lockhead.lpf.plugins.plugin;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import nl.lockhead.lpf.exceptions.InvalidPluginException;
import nl.lockhead.lpf.plugins.plugin.Version;
import nl.lockhead.lpf.tools.Matching;

public class PluginConfig {
    private final Map<String, Object> meta = new LinkedHashMap<String, Object>();
    private String name;
    private String author;
    private boolean registerEvents;
    private Version version;

    private PluginConfig(String name, String author, Version version) {
        this(name, author, version, true);
    }

    private PluginConfig(String name, String author, Version version, boolean registerEvents) {
        this.name = name;
        this.author = author;
        this.registerEvents = registerEvents;
        this.version = version;
    }

    public static PluginConfig createConfig(String pluginName, String pluginAuthor, Version version) {
        try {
            if (pluginName == null) {
                throw new InvalidPluginException("Invalid plugin name: null");
            }
            pluginName = pluginName.trim();
            if (pluginAuthor == null) {
                throw new InvalidPluginException("Invalid plugin author name: null");
            }
            pluginAuthor = pluginAuthor.trim();
            if (version == null) {
                throw new InvalidPluginException("Invalid version: null");
            }
            if (!Matching.MATCH_64.matcher(pluginName).matches()) {
                throw new InvalidPluginException("Invalid plugin name: Plugin names are to be alphanumeric and between 3 and 64 characters");
            }
            if (!Matching.MATCH_64.matcher(pluginAuthor).matches()) {
                throw new InvalidPluginException("Invalid plugin name: Plugin Author names are to be alphanumeric and between 3 and 64 characters");
            }
        }
        catch (InvalidPluginException e) {
            e.printStackTrace();
            return null;
        }
        return new PluginConfig(pluginName, pluginAuthor, version);
    }

    public static PluginConfig createConfig(String pluginName, String pluginAuthor, Version version, boolean registerEvents) {
        try {
            if (pluginName == null) {
                throw new InvalidPluginException("Invalid plugin name: null");
            }
            pluginName = pluginName.trim();
            if (pluginAuthor == null) {
                throw new InvalidPluginException("Invalid plugin author name: null");
            }
            pluginAuthor = pluginAuthor.trim();
            if (version == null) {
                throw new InvalidPluginException("Invalid version: null");
            }
            if (!Matching.MATCH_64.matcher(pluginName).matches()) {
                throw new InvalidPluginException("Invalid plugin name: Plugin names are to be alphanumeric and between 3 and 64 characters");
            }
            if (!Matching.MATCH_64.matcher(pluginAuthor).matches()) {
                throw new InvalidPluginException("Invalid plugin name: Plugin Author names are to be alphanumeric and between 3 and 64 characters");
            }
        }
        catch (InvalidPluginException e) {
            e.printStackTrace();
            return null;
        }
        return new PluginConfig(pluginName, pluginAuthor, version, registerEvents);
    }

    public final void setPluginName(String pluginName) throws InvalidPluginException {
        if (pluginName == null) {
            throw new InvalidPluginException("Invalid plugin name: null");
        }
        if (!Matching.MATCH_64.matcher(pluginName).matches()) {
            throw new InvalidPluginException("Invalid plugin name: Plugin names are to be alphanumeric and between 3 and 64 characters");
        }
        this.name = pluginName = pluginName.trim();
    }

    public final void setPluginAuthor(String authorName) throws InvalidPluginException {
        if (authorName == null) {
            throw new InvalidPluginException("Invalid plugin author name: null");
        }
        if (!Matching.MATCH_64.matcher(authorName).matches()) {
            throw new InvalidPluginException("Invalid plugin name: Plugin Author names are to be alphanumeric and between 3 and 64 characters");
        }
        this.author = authorName = authorName.trim();
    }

    public final void setPluginVersion(Version pluginVersion) throws InvalidPluginException {
        if (this.version == null) {
            throw new InvalidPluginException("Invalid version: null");
        }
        this.version = pluginVersion;
    }

    public final String getName() {
        return this.name;
    }

    public final String getAuthor() {
        return this.author;
    }

    public final boolean shouldRegisterEvents() {
        return this.registerEvents;
    }

    public Version getVersion() {
        return this.version;
    }

    public void addMetadata(String key, Object value) {
        this.meta.put(key, value);
    }

    public void removeMetadata(String key) {
        this.meta.remove(key);
    }

    public Map<String, Object> getMetadataMap() {
        return new HashMap<String, Object>(this.meta);
    }
}

