/*
 * Decompiled with CFR 0.152.
 */
package nl.lockhead.lpf.plugins.plugin;

import java.util.regex.Pattern;

public class Version {
    private static final Pattern VERSION = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,6}");
    private final Short major;
    private final Short minor;
    private final Short patch;

    public Version(Short major, Short minor, Short patch) {
        this.major = major == null ? Short.valueOf((short)0) : major;
        this.minor = minor == null ? Short.valueOf((short)0) : minor;
        this.patch = patch == null ? Short.valueOf((short)1) : patch;
    }

    public Version(Integer major, Integer minor, Integer patch) {
        this.major = (short)(major == null ? (int)Short.valueOf((short)0).shortValue() : major);
        this.minor = (short)(minor == null ? (int)Short.valueOf((short)0).shortValue() : minor);
        this.patch = (short)(patch == null ? (int)Short.valueOf((short)1).shortValue() : patch);
    }

    public static Version getVersion(String versionString) {
        return Version.parseVersion(versionString);
    }

    public static Version parseVersion(String versionString) {
        if (!VERSION.matcher(versionString = versionString.replaceAll("[^\\d.]", "")).matches()) {
            throw new IllegalArgumentException("version string must match MAJOR.MINOR.PATCH");
        }
        String[] s = versionString.split("\\.");
        return new Version(Short.parseShort(s[0]), Short.parseShort(s[1]), Short.parseShort(s[2]));
    }

    public final short getMajor() {
        return this.major;
    }

    public final short getMinor() {
        return this.minor;
    }

    public final short getPatch() {
        return this.patch;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.patch;
    }

    public String getAsString() {
        return this.toString();
    }
}

