/*
 * Decompiled with CFR 0.152.
 */
package nl.lockhead.lpf.tools;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Scanner;
import nl.lockhead.lpf.tools.Matching;

public final class FileManager {
    public static String lastFile = "";
    private static List<String> EXTENSIONS = Arrays.asList(".txt", ".log", ".json", ".xml", ".lh", ".bat");

    private FileManager() throws IllegalAccessException {
        throw new IllegalAccessException("Yeah nah yeah nah nah yeah");
    }

    public static String getWorkingDirectory() {
        try {
            if (Matching.MATCH_NON.matcher(System.getProperty("os.name").toLowerCase()).replaceAll("").contains("windows")) {
                return new File(FileManager.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath().substring(1)).getParentFile().getAbsolutePath();
            }
            return new File(FileManager.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath()).getParentFile().getAbsolutePath();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static File getThisFile() {
        try {
            if (Matching.MATCH_NON.matcher(System.getProperty("os.name").toLowerCase()).replaceAll("").contains("windows")) {
                return new File(FileManager.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath().substring(1));
            }
            return new File(FileManager.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void deleteDirectory(File f) {
        if (!f.isDirectory()) {
            return;
        }
        for (File d : Objects.requireNonNull(f.listFiles())) {
            if (!d.isFile()) continue;
            d.delete();
        }
    }

    public static void deleteDirectoryAndSubs(File f) {
        for (File d : Objects.requireNonNull(f.listFiles())) {
            if (d.isFile()) {
                d.delete();
                continue;
            }
            if (!d.isDirectory()) continue;
            FileManager.deleteDirectoryAndSubs(d);
        }
    }

    /*
     * Exception decompiling
     */
    public static String[] readFile(String file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readFile(URL file) {
        try {
            StringBuilder result = new StringBuilder();
            try (Scanner scanner = new Scanner(new File(file.getFile().replace("%20", " ")));){
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine();
                    result.append(line).append("\n");
                }
                String string = result.toString();
                return string;
            }
            catch (Exception exception) {
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String readFile(File file) {
        String contents = "";
        try {
            byte[] byt = Files.readAllBytes(file.toPath());
            return new String(byt, Charset.defaultCharset());
        }
        catch (IOException e) {
            e.printStackTrace();
            return contents;
        }
    }

    public static void writeToFile(File file, String contents, boolean clearBeforeWrite) {
        try {
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
                if (clearBeforeWrite) {
                    writer.write("");
                }
                writer.append(contents);
            }
        }
        catch (Exception e) {
            System.err.println("====================DEBUG INFO=====================");
            System.err.println("file: " + file);
            System.err.println("file path: " + file.getAbsolutePath());
            e.printStackTrace();
        }
    }

    public static void move(File from, File to) {
        try {
            Files.move(from.toPath(), to.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void copy(File file, File to) {
        try {
            Files.copy(file.toPath(), to.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void delete(File file) {
        try {
            Files.deleteIfExists(file.toPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void rename(File file, File to) {
        file.renameTo(to);
    }

    public static void download(URL from, File file) throws IOException {
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        URLConnection uc = from.openConnection();
        uc.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)");
        try (ReadableByteChannel rbc = Channels.newChannel(uc.getInputStream());
             FileOutputStream fos = new FileOutputStream(file);){
            fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
        }
    }
}

