/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/log.proto

// Protobuf Java Version: 3.25.5
package shaded.xolir.com.google.api;

/**
 *
 *
 * <pre>
 * A description of a log type. Example in YAML format:
 *
 *     - name: library.googleapis.com/activity_history
 *       description: The history of borrowing and returning library items.
 *       display_name: Activity
 *       labels:
 *       - key: /customer_id
 *         description: Identifier of a library customer
 * </pre>
 *
 * Protobuf type {@code google.api.LogDescriptor}
 */
public final class LogDescriptor extends shaded.xolir.com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.api.LogDescriptor)
    LogDescriptorOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use LogDescriptor.newBuilder() to construct.
  private LogDescriptor(shaded.xolir.com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private LogDescriptor() {
    name_ = "";
    labels_ = java.util.Collections.emptyList();
    description_ = "";
    displayName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new LogDescriptor();
  }

  public static final shaded.xolir.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.api.LogProto.internal_static_google_api_LogDescriptor_descriptor;
  }

  @java.lang.Override
  protected shaded.xolir.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.api.LogProto.internal_static_google_api_LogDescriptor_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            shaded.xolir.com.google.api.LogDescriptor.class, shaded.xolir.com.google.api.LogDescriptor.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The name of the log. It must be less than 512 characters long and can
   * include the following characters: upper- and lower-case alphanumeric
   * characters [A-Za-z0-9], and punctuation characters including
   * slash, underscore, hyphen, period [/_-.].
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      shaded.xolir.com.google.protobuf.ByteString bs = (shaded.xolir.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the log. It must be less than 512 characters long and can
   * include the following characters: upper- and lower-case alphanumeric
   * characters [A-Za-z0-9], and punctuation characters including
   * slash, underscore, hyphen, period [/_-.].
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public shaded.xolir.com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      shaded.xolir.com.google.protobuf.ByteString b =
          shaded.xolir.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (shaded.xolir.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<shaded.xolir.com.google.api.LabelDescriptor> labels_;
  /**
   *
   *
   * <pre>
   * The set of labels that are available to describe a specific log entry.
   * Runtime requests that contain labels not specified here are
   * considered invalid.
   * </pre>
   *
   * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
   */
  @java.lang.Override
  public java.util.List<shaded.xolir.com.google.api.LabelDescriptor> getLabelsList() {
    return labels_;
  }
  /**
   *
   *
   * <pre>
   * The set of labels that are available to describe a specific log entry.
   * Runtime requests that contain labels not specified here are
   * considered invalid.
   * </pre>
   *
   * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends shaded.xolir.com.google.api.LabelDescriptorOrBuilder>
      getLabelsOrBuilderList() {
    return labels_;
  }
  /**
   *
   *
   * <pre>
   * The set of labels that are available to describe a specific log entry.
   * Runtime requests that contain labels not specified here are
   * considered invalid.
   * </pre>
   *
   * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
   */
  @java.lang.Override
  public int getLabelsCount() {
    return labels_.size();
  }
  /**
   *
   *
   * <pre>
   * The set of labels that are available to describe a specific log entry.
   * Runtime requests that contain labels not specified here are
   * considered invalid.
   * </pre>
   *
   * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
   */
  @java.lang.Override
  public shaded.xolir.com.google.api.LabelDescriptor getLabels(int index) {
    return labels_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The set of labels that are available to describe a specific log entry.
   * Runtime requests that contain labels not specified here are
   * considered invalid.
   * </pre>
   *
   * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
   */
  @java.lang.Override
  public shaded.xolir.com.google.api.LabelDescriptorOrBuilder getLabelsOrBuilder(int index) {
    return labels_.get(index);
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * A human-readable description of this log. This information appears in
   * the documentation and can contain details.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      shaded.xolir.com.google.protobuf.ByteString bs = (shaded.xolir.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A human-readable description of this log. This information appears in
   * the documentation and can contain details.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public shaded.xolir.com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      shaded.xolir.com.google.protobuf.ByteString b =
          shaded.xolir.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (shaded.xolir.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * The human-readable name for this log. This information appears on
   * the user interface and should be concise.
   * </pre>
   *
   * <code>string display_name = 4;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      shaded.xolir.com.google.protobuf.ByteString bs = (shaded.xolir.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The human-readable name for this log. This information appears on
   * the user interface and should be concise.
   * </pre>
   *
   * <code>string display_name = 4;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public shaded.xolir.com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      shaded.xolir.com.google.protobuf.ByteString b =
          shaded.xolir.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (shaded.xolir.com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(shaded.xolir.com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!shaded.xolir.com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      shaded.xolir.com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    for (int i = 0; i < labels_.size(); i++) {
      output.writeMessage(2, labels_.get(i));
    }
    if (!shaded.xolir.com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      shaded.xolir.com.google.protobuf.GeneratedMessageV3.writeString(output, 3, description_);
    }
    if (!shaded.xolir.com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      shaded.xolir.com.google.protobuf.GeneratedMessageV3.writeString(output, 4, displayName_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!shaded.xolir.com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += shaded.xolir.com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    for (int i = 0; i < labels_.size(); i++) {
      size += shaded.xolir.com.google.protobuf.CodedOutputStream.computeMessageSize(2, labels_.get(i));
    }
    if (!shaded.xolir.com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += shaded.xolir.com.google.protobuf.GeneratedMessageV3.computeStringSize(3, description_);
    }
    if (!shaded.xolir.com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += shaded.xolir.com.google.protobuf.GeneratedMessageV3.computeStringSize(4, displayName_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.api.LogDescriptor)) {
      return super.equals(obj);
    }
    shaded.xolir.com.google.api.LogDescriptor other = (shaded.xolir.com.google.api.LogDescriptor) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getLabelsList().equals(other.getLabelsList())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (getLabelsCount() > 0) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + getLabelsList().hashCode();
    }
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static shaded.xolir.com.google.api.LogDescriptor parseFrom(java.nio.ByteBuffer data)
      throws shaded.xolir.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static shaded.xolir.com.google.api.LogDescriptor parseFrom(
      java.nio.ByteBuffer data, shaded.xolir.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws shaded.xolir.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static shaded.xolir.com.google.api.LogDescriptor parseFrom(shaded.xolir.com.google.protobuf.ByteString data)
      throws shaded.xolir.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static shaded.xolir.com.google.api.LogDescriptor parseFrom(
      shaded.xolir.com.google.protobuf.ByteString data,
      shaded.xolir.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws shaded.xolir.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static shaded.xolir.com.google.api.LogDescriptor parseFrom(byte[] data)
      throws shaded.xolir.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static shaded.xolir.com.google.api.LogDescriptor parseFrom(
      byte[] data, shaded.xolir.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws shaded.xolir.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static shaded.xolir.com.google.api.LogDescriptor parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static shaded.xolir.com.google.api.LogDescriptor parseFrom(
      java.io.InputStream input, shaded.xolir.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static shaded.xolir.com.google.api.LogDescriptor parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static shaded.xolir.com.google.api.LogDescriptor parseDelimitedFrom(
      java.io.InputStream input, shaded.xolir.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static shaded.xolir.com.google.api.LogDescriptor parseFrom(shaded.xolir.com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static shaded.xolir.com.google.api.LogDescriptor parseFrom(
      shaded.xolir.com.google.protobuf.CodedInputStream input,
      shaded.xolir.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(shaded.xolir.com.google.api.LogDescriptor prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(shaded.xolir.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A description of a log type. Example in YAML format:
   *
   *     - name: library.googleapis.com/activity_history
   *       description: The history of borrowing and returning library items.
   *       display_name: Activity
   *       labels:
   *       - key: /customer_id
   *         description: Identifier of a library customer
   * </pre>
   *
   * Protobuf type {@code google.api.LogDescriptor}
   */
  public static final class Builder extends shaded.xolir.com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.api.LogDescriptor)
      com.google.api.LogDescriptorOrBuilder {
    public static final shaded.xolir.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.api.LogProto.internal_static_google_api_LogDescriptor_descriptor;
    }

    @java.lang.Override
    protected shaded.xolir.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.LogProto.internal_static_google_api_LogDescriptor_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              shaded.xolir.com.google.api.LogDescriptor.class, shaded.xolir.com.google.api.LogDescriptor.Builder.class);
    }

    // Construct using com.google.api.LogDescriptor.newBuilder()
    private Builder() {}

    private Builder(shaded.xolir.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      if (labelsBuilder_ == null) {
        labels_ = java.util.Collections.emptyList();
      } else {
        labels_ = null;
        labelsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      description_ = "";
      displayName_ = "";
      return this;
    }

    @java.lang.Override
    public shaded.xolir.com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.api.LogProto.internal_static_google_api_LogDescriptor_descriptor;
    }

    @java.lang.Override
    public shaded.xolir.com.google.api.LogDescriptor getDefaultInstanceForType() {
      return com.google.api.LogDescriptor.getDefaultInstance();
    }

    @java.lang.Override
    public shaded.xolir.com.google.api.LogDescriptor build() {
      shaded.xolir.com.google.api.LogDescriptor result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public shaded.xolir.com.google.api.LogDescriptor buildPartial() {
      shaded.xolir.com.google.api.LogDescriptor result = new com.google.api.LogDescriptor(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(shaded.xolir.com.google.api.LogDescriptor result) {
      if (labelsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          labels_ = java.util.Collections.unmodifiableList(labels_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.labels_ = labels_;
      } else {
        result.labels_ = labelsBuilder_.build();
      }
    }

    private void buildPartial0(shaded.xolir.com.google.api.LogDescriptor result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.displayName_ = displayName_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        shaded.xolir.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(shaded.xolir.com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(shaded.xolir.com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        shaded.xolir.com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        shaded.xolir.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(shaded.xolir.com.google.protobuf.Message other) {
      if (other instanceof com.google.api.LogDescriptor) {
        return mergeFrom((shaded.xolir.com.google.api.LogDescriptor) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(shaded.xolir.com.google.api.LogDescriptor other) {
      if (other == shaded.xolir.com.google.api.LogDescriptor.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (labelsBuilder_ == null) {
        if (!other.labels_.isEmpty()) {
          if (labels_.isEmpty()) {
            labels_ = other.labels_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureLabelsIsMutable();
            labels_.addAll(other.labels_);
          }
          onChanged();
        }
      } else {
        if (!other.labels_.isEmpty()) {
          if (labelsBuilder_.isEmpty()) {
            labelsBuilder_.dispose();
            labelsBuilder_ = null;
            labels_ = other.labels_;
            bitField0_ = (bitField0_ & ~0x00000002);
            labelsBuilder_ =
                shaded.xolir.com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getLabelsFieldBuilder()
                    : null;
          } else {
            labelsBuilder_.addAllMessages(other.labels_);
          }
        }
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        shaded.xolir.com.google.protobuf.CodedInputStream input,
        shaded.xolir.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                shaded.xolir.com.google.api.LabelDescriptor m =
                    input.readMessage(shaded.xolir.com.google.api.LabelDescriptor.parser(), extensionRegistry);
                if (labelsBuilder_ == null) {
                  ensureLabelsIsMutable();
                  labels_.add(m);
                } else {
                  labelsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (shaded.xolir.com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The name of the log. It must be less than 512 characters long and can
     * include the following characters: upper- and lower-case alphanumeric
     * characters [A-Za-z0-9], and punctuation characters including
     * slash, underscore, hyphen, period [/_-.].
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        shaded.xolir.com.google.protobuf.ByteString bs = (shaded.xolir.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the log. It must be less than 512 characters long and can
     * include the following characters: upper- and lower-case alphanumeric
     * characters [A-Za-z0-9], and punctuation characters including
     * slash, underscore, hyphen, period [/_-.].
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public shaded.xolir.com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        shaded.xolir.com.google.protobuf.ByteString b =
            shaded.xolir.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (shaded.xolir.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the log. It must be less than 512 characters long and can
     * include the following characters: upper- and lower-case alphanumeric
     * characters [A-Za-z0-9], and punctuation characters including
     * slash, underscore, hyphen, period [/_-.].
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the log. It must be less than 512 characters long and can
     * include the following characters: upper- and lower-case alphanumeric
     * characters [A-Za-z0-9], and punctuation characters including
     * slash, underscore, hyphen, period [/_-.].
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the log. It must be less than 512 characters long and can
     * include the following characters: upper- and lower-case alphanumeric
     * characters [A-Za-z0-9], and punctuation characters including
     * slash, underscore, hyphen, period [/_-.].
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(shaded.xolir.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<shaded.xolir.com.google.api.LabelDescriptor> labels_ =
        java.util.Collections.emptyList();

    private void ensureLabelsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        labels_ = new java.util.ArrayList<shaded.xolir.com.google.api.LabelDescriptor>(labels_);
        bitField0_ |= 0x00000002;
      }
    }

    private shaded.xolir.com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.LabelDescriptor,
            shaded.xolir.com.google.api.LabelDescriptor.Builder,
            shaded.xolir.com.google.api.LabelDescriptorOrBuilder>
        labelsBuilder_;

    /**
     *
     *
     * <pre>
     * The set of labels that are available to describe a specific log entry.
     * Runtime requests that contain labels not specified here are
     * considered invalid.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     */
    public java.util.List<shaded.xolir.com.google.api.LabelDescriptor> getLabelsList() {
      if (labelsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(labels_);
      } else {
        return labelsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The set of labels that are available to describe a specific log entry.
     * Runtime requests that contain labels not specified here are
     * considered invalid.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     */
    public int getLabelsCount() {
      if (labelsBuilder_ == null) {
        return labels_.size();
      } else {
        return labelsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The set of labels that are available to describe a specific log entry.
     * Runtime requests that contain labels not specified here are
     * considered invalid.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     */
    public shaded.xolir.com.google.api.LabelDescriptor getLabels(int index) {
      if (labelsBuilder_ == null) {
        return labels_.get(index);
      } else {
        return labelsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The set of labels that are available to describe a specific log entry.
     * Runtime requests that contain labels not specified here are
     * considered invalid.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     */
    public Builder setLabels(int index, shaded.xolir.com.google.api.LabelDescriptor value) {
      if (labelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLabelsIsMutable();
        labels_.set(index, value);
        onChanged();
      } else {
        labelsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The set of labels that are available to describe a specific log entry.
     * Runtime requests that contain labels not specified here are
     * considered invalid.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     */
    public Builder setLabels(int index, shaded.xolir.com.google.api.LabelDescriptor.Builder builderForValue) {
      if (labelsBuilder_ == null) {
        ensureLabelsIsMutable();
        labels_.set(index, builderForValue.build());
        onChanged();
      } else {
        labelsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The set of labels that are available to describe a specific log entry.
     * Runtime requests that contain labels not specified here are
     * considered invalid.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     */
    public Builder addLabels(shaded.xolir.com.google.api.LabelDescriptor value) {
      if (labelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLabelsIsMutable();
        labels_.add(value);
        onChanged();
      } else {
        labelsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The set of labels that are available to describe a specific log entry.
     * Runtime requests that contain labels not specified here are
     * considered invalid.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     */
    public Builder addLabels(int index, shaded.xolir.com.google.api.LabelDescriptor value) {
      if (labelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLabelsIsMutable();
        labels_.add(index, value);
        onChanged();
      } else {
        labelsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The set of labels that are available to describe a specific log entry.
     * Runtime requests that contain labels not specified here are
     * considered invalid.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     */
    public Builder addLabels(shaded.xolir.com.google.api.LabelDescriptor.Builder builderForValue) {
      if (labelsBuilder_ == null) {
        ensureLabelsIsMutable();
        labels_.add(builderForValue.build());
        onChanged();
      } else {
        labelsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The set of labels that are available to describe a specific log entry.
     * Runtime requests that contain labels not specified here are
     * considered invalid.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     */
    public Builder addLabels(int index, shaded.xolir.com.google.api.LabelDescriptor.Builder builderForValue) {
      if (labelsBuilder_ == null) {
        ensureLabelsIsMutable();
        labels_.add(index, builderForValue.build());
        onChanged();
      } else {
        labelsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The set of labels that are available to describe a specific log entry.
     * Runtime requests that contain labels not specified here are
     * considered invalid.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     */
    public Builder addAllLabels(
        java.lang.Iterable<? extends shaded.xolir.com.google.api.LabelDescriptor> values) {
      if (labelsBuilder_ == null) {
        ensureLabelsIsMutable();
        shaded.xolir.com.google.protobuf.AbstractMessageLite.Builder.addAll(values, labels_);
        onChanged();
      } else {
        labelsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The set of labels that are available to describe a specific log entry.
     * Runtime requests that contain labels not specified here are
     * considered invalid.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     */
    public Builder clearLabels() {
      if (labelsBuilder_ == null) {
        labels_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        labelsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The set of labels that are available to describe a specific log entry.
     * Runtime requests that contain labels not specified here are
     * considered invalid.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     */
    public Builder removeLabels(int index) {
      if (labelsBuilder_ == null) {
        ensureLabelsIsMutable();
        labels_.remove(index);
        onChanged();
      } else {
        labelsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The set of labels that are available to describe a specific log entry.
     * Runtime requests that contain labels not specified here are
     * considered invalid.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     */
    public shaded.xolir.com.google.api.LabelDescriptor.Builder getLabelsBuilder(int index) {
      return getLabelsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The set of labels that are available to describe a specific log entry.
     * Runtime requests that contain labels not specified here are
     * considered invalid.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     */
    public shaded.xolir.com.google.api.LabelDescriptorOrBuilder getLabelsOrBuilder(int index) {
      if (labelsBuilder_ == null) {
        return labels_.get(index);
      } else {
        return labelsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The set of labels that are available to describe a specific log entry.
     * Runtime requests that contain labels not specified here are
     * considered invalid.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     */
    public java.util.List<? extends shaded.xolir.com.google.api.LabelDescriptorOrBuilder>
        getLabelsOrBuilderList() {
      if (labelsBuilder_ != null) {
        return labelsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(labels_);
      }
    }
    /**
     *
     *
     * <pre>
     * The set of labels that are available to describe a specific log entry.
     * Runtime requests that contain labels not specified here are
     * considered invalid.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     */
    public shaded.xolir.com.google.api.LabelDescriptor.Builder addLabelsBuilder() {
      return getLabelsFieldBuilder()
          .addBuilder(shaded.xolir.com.google.api.LabelDescriptor.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The set of labels that are available to describe a specific log entry.
     * Runtime requests that contain labels not specified here are
     * considered invalid.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     */
    public shaded.xolir.com.google.api.LabelDescriptor.Builder addLabelsBuilder(int index) {
      return getLabelsFieldBuilder()
          .addBuilder(index, shaded.xolir.com.google.api.LabelDescriptor.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The set of labels that are available to describe a specific log entry.
     * Runtime requests that contain labels not specified here are
     * considered invalid.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     */
    public java.util.List<shaded.xolir.com.google.api.LabelDescriptor.Builder> getLabelsBuilderList() {
      return getLabelsFieldBuilder().getBuilderList();
    }

    private shaded.xolir.com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.LabelDescriptor,
            shaded.xolir.com.google.api.LabelDescriptor.Builder,
            shaded.xolir.com.google.api.LabelDescriptorOrBuilder>
        getLabelsFieldBuilder() {
      if (labelsBuilder_ == null) {
        labelsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.api.LabelDescriptor,
                shaded.xolir.com.google.api.LabelDescriptor.Builder,
                shaded.xolir.com.google.api.LabelDescriptorOrBuilder>(
                labels_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        labels_ = null;
      }
      return labelsBuilder_;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * A human-readable description of this log. This information appears in
     * the documentation and can contain details.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        shaded.xolir.com.google.protobuf.ByteString bs = (shaded.xolir.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A human-readable description of this log. This information appears in
     * the documentation and can contain details.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The bytes for description.
     */
    public shaded.xolir.com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        shaded.xolir.com.google.protobuf.ByteString b =
            shaded.xolir.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (shaded.xolir.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A human-readable description of this log. This information appears in
     * the documentation and can contain details.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A human-readable description of this log. This information appears in
     * the documentation and can contain details.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A human-readable description of this log. This information appears in
     * the documentation and can contain details.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(shaded.xolir.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * The human-readable name for this log. This information appears on
     * the user interface and should be concise.
     * </pre>
     *
     * <code>string display_name = 4;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        shaded.xolir.com.google.protobuf.ByteString bs = (shaded.xolir.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The human-readable name for this log. This information appears on
     * the user interface and should be concise.
     * </pre>
     *
     * <code>string display_name = 4;</code>
     *
     * @return The bytes for displayName.
     */
    public shaded.xolir.com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        shaded.xolir.com.google.protobuf.ByteString b =
            shaded.xolir.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (shaded.xolir.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The human-readable name for this log. This information appears on
     * the user interface and should be concise.
     * </pre>
     *
     * <code>string display_name = 4;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The human-readable name for this log. This information appears on
     * the user interface and should be concise.
     * </pre>
     *
     * <code>string display_name = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The human-readable name for this log. This information appears on
     * the user interface and should be concise.
     * </pre>
     *
     * <code>string display_name = 4;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(shaded.xolir.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final shaded.xolir.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final shaded.xolir.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.api.LogDescriptor)
  }

  // @@protoc_insertion_point(class_scope:google.api.LogDescriptor)
  private static final shaded.xolir.com.google.api.LogDescriptor DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.api.LogDescriptor();
  }

  public static shaded.xolir.com.google.api.LogDescriptor getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final shaded.xolir.com.google.protobuf.Parser<LogDescriptor> PARSER =
      new com.google.protobuf.AbstractParser<LogDescriptor>() {
        @java.lang.Override
        public LogDescriptor parsePartialFrom(
            shaded.xolir.com.google.protobuf.CodedInputStream input,
            shaded.xolir.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws shaded.xolir.com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (shaded.xolir.com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (shaded.xolir.com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static shaded.xolir.com.google.protobuf.Parser<LogDescriptor> parser() {
    return PARSER;
  }

  @java.lang.Override
  public shaded.xolir.com.google.protobuf.Parser<LogDescriptor> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public shaded.xolir.com.google.api.LogDescriptor getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
