/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/auth.proto

// Protobuf Java Version: 3.25.5
package shaded.xolir.com.google.api;

/**
 *
 *
 * <pre>
 * OAuth scopes are a way to define data and permissions on data. For example,
 * there are scopes defined for "Read-only access to Google Calendar" and
 * "Access to Cloud Platform". Users can consent to a scope for an application,
 * giving it permission to access that data on their behalf.
 *
 * OAuth scope specifications should be fairly coarse grained; a user will need
 * to see and understand the text description of what your scope means.
 *
 * In most cases: use one or at most two OAuth scopes for an entire family of
 * products. If your product has multiple APIs, you should probably be sharing
 * the OAuth scope across all of those APIs.
 *
 * When you need finer grained OAuth consent screens: talk with your product
 * management about how developers will use them in practice.
 *
 * Please note that even though each of the canonical scopes is enough for a
 * request to be accepted and passed to the backend, a request can still fail
 * due to the backend requiring additional scopes or permissions.
 * </pre>
 *
 * Protobuf type {@code google.api.OAuthRequirements}
 */
public final class OAuthRequirements extends shaded.xolir.com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.api.OAuthRequirements)
    OAuthRequirementsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use OAuthRequirements.newBuilder() to construct.
  private OAuthRequirements(shaded.xolir.com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private OAuthRequirements() {
    canonicalScopes_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new OAuthRequirements();
  }

  public static final shaded.xolir.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.api.AuthProto.internal_static_google_api_OAuthRequirements_descriptor;
  }

  @java.lang.Override
  protected shaded.xolir.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.api.AuthProto.internal_static_google_api_OAuthRequirements_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            shaded.xolir.com.google.api.OAuthRequirements.class, shaded.xolir.com.google.api.OAuthRequirements.Builder.class);
  }

  public static final int CANONICAL_SCOPES_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object canonicalScopes_ = "";
  /**
   *
   *
   * <pre>
   * The list of publicly documented OAuth scopes that are allowed access. An
   * OAuth token containing any of these scopes will be accepted.
   *
   * Example:
   *
   *      canonical_scopes: https://www.googleapis.com/auth/calendar,
   *                        https://www.googleapis.com/auth/calendar.read
   * </pre>
   *
   * <code>string canonical_scopes = 1;</code>
   *
   * @return The canonicalScopes.
   */
  @java.lang.Override
  public java.lang.String getCanonicalScopes() {
    java.lang.Object ref = canonicalScopes_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      shaded.xolir.com.google.protobuf.ByteString bs = (shaded.xolir.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      canonicalScopes_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The list of publicly documented OAuth scopes that are allowed access. An
   * OAuth token containing any of these scopes will be accepted.
   *
   * Example:
   *
   *      canonical_scopes: https://www.googleapis.com/auth/calendar,
   *                        https://www.googleapis.com/auth/calendar.read
   * </pre>
   *
   * <code>string canonical_scopes = 1;</code>
   *
   * @return The bytes for canonicalScopes.
   */
  @java.lang.Override
  public shaded.xolir.com.google.protobuf.ByteString getCanonicalScopesBytes() {
    java.lang.Object ref = canonicalScopes_;
    if (ref instanceof java.lang.String) {
      shaded.xolir.com.google.protobuf.ByteString b =
          shaded.xolir.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      canonicalScopes_ = b;
      return b;
    } else {
      return (shaded.xolir.com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(shaded.xolir.com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!shaded.xolir.com.google.protobuf.GeneratedMessageV3.isStringEmpty(canonicalScopes_)) {
      shaded.xolir.com.google.protobuf.GeneratedMessageV3.writeString(output, 1, canonicalScopes_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!shaded.xolir.com.google.protobuf.GeneratedMessageV3.isStringEmpty(canonicalScopes_)) {
      size += shaded.xolir.com.google.protobuf.GeneratedMessageV3.computeStringSize(1, canonicalScopes_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.api.OAuthRequirements)) {
      return super.equals(obj);
    }
    shaded.xolir.com.google.api.OAuthRequirements other = (shaded.xolir.com.google.api.OAuthRequirements) obj;

    if (!getCanonicalScopes().equals(other.getCanonicalScopes())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + CANONICAL_SCOPES_FIELD_NUMBER;
    hash = (53 * hash) + getCanonicalScopes().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static shaded.xolir.com.google.api.OAuthRequirements parseFrom(java.nio.ByteBuffer data)
      throws shaded.xolir.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static shaded.xolir.com.google.api.OAuthRequirements parseFrom(
      java.nio.ByteBuffer data, shaded.xolir.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws shaded.xolir.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static shaded.xolir.com.google.api.OAuthRequirements parseFrom(shaded.xolir.com.google.protobuf.ByteString data)
      throws shaded.xolir.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static shaded.xolir.com.google.api.OAuthRequirements parseFrom(
      shaded.xolir.com.google.protobuf.ByteString data,
      shaded.xolir.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws shaded.xolir.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static shaded.xolir.com.google.api.OAuthRequirements parseFrom(byte[] data)
      throws shaded.xolir.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static shaded.xolir.com.google.api.OAuthRequirements parseFrom(
      byte[] data, shaded.xolir.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws shaded.xolir.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static shaded.xolir.com.google.api.OAuthRequirements parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static shaded.xolir.com.google.api.OAuthRequirements parseFrom(
      java.io.InputStream input, shaded.xolir.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static shaded.xolir.com.google.api.OAuthRequirements parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static shaded.xolir.com.google.api.OAuthRequirements parseDelimitedFrom(
      java.io.InputStream input, shaded.xolir.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static shaded.xolir.com.google.api.OAuthRequirements parseFrom(
      shaded.xolir.com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static shaded.xolir.com.google.api.OAuthRequirements parseFrom(
      shaded.xolir.com.google.protobuf.CodedInputStream input,
      shaded.xolir.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(shaded.xolir.com.google.api.OAuthRequirements prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(shaded.xolir.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * OAuth scopes are a way to define data and permissions on data. For example,
   * there are scopes defined for "Read-only access to Google Calendar" and
   * "Access to Cloud Platform". Users can consent to a scope for an application,
   * giving it permission to access that data on their behalf.
   *
   * OAuth scope specifications should be fairly coarse grained; a user will need
   * to see and understand the text description of what your scope means.
   *
   * In most cases: use one or at most two OAuth scopes for an entire family of
   * products. If your product has multiple APIs, you should probably be sharing
   * the OAuth scope across all of those APIs.
   *
   * When you need finer grained OAuth consent screens: talk with your product
   * management about how developers will use them in practice.
   *
   * Please note that even though each of the canonical scopes is enough for a
   * request to be accepted and passed to the backend, a request can still fail
   * due to the backend requiring additional scopes or permissions.
   * </pre>
   *
   * Protobuf type {@code google.api.OAuthRequirements}
   */
  public static final class Builder extends shaded.xolir.com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.api.OAuthRequirements)
      com.google.api.OAuthRequirementsOrBuilder {
    public static final shaded.xolir.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.api.AuthProto.internal_static_google_api_OAuthRequirements_descriptor;
    }

    @java.lang.Override
    protected shaded.xolir.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.AuthProto
          .internal_static_google_api_OAuthRequirements_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              shaded.xolir.com.google.api.OAuthRequirements.class,
              shaded.xolir.com.google.api.OAuthRequirements.Builder.class);
    }

    // Construct using com.google.api.OAuthRequirements.newBuilder()
    private Builder() {}

    private Builder(shaded.xolir.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      canonicalScopes_ = "";
      return this;
    }

    @java.lang.Override
    public shaded.xolir.com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.api.AuthProto.internal_static_google_api_OAuthRequirements_descriptor;
    }

    @java.lang.Override
    public shaded.xolir.com.google.api.OAuthRequirements getDefaultInstanceForType() {
      return com.google.api.OAuthRequirements.getDefaultInstance();
    }

    @java.lang.Override
    public shaded.xolir.com.google.api.OAuthRequirements build() {
      shaded.xolir.com.google.api.OAuthRequirements result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public shaded.xolir.com.google.api.OAuthRequirements buildPartial() {
      shaded.xolir.com.google.api.OAuthRequirements result = new com.google.api.OAuthRequirements(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(shaded.xolir.com.google.api.OAuthRequirements result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.canonicalScopes_ = canonicalScopes_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        shaded.xolir.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(shaded.xolir.com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(shaded.xolir.com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        shaded.xolir.com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        shaded.xolir.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(shaded.xolir.com.google.protobuf.Message other) {
      if (other instanceof com.google.api.OAuthRequirements) {
        return mergeFrom((shaded.xolir.com.google.api.OAuthRequirements) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(shaded.xolir.com.google.api.OAuthRequirements other) {
      if (other == shaded.xolir.com.google.api.OAuthRequirements.getDefaultInstance()) return this;
      if (!other.getCanonicalScopes().isEmpty()) {
        canonicalScopes_ = other.canonicalScopes_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        shaded.xolir.com.google.protobuf.CodedInputStream input,
        shaded.xolir.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                canonicalScopes_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (shaded.xolir.com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object canonicalScopes_ = "";
    /**
     *
     *
     * <pre>
     * The list of publicly documented OAuth scopes that are allowed access. An
     * OAuth token containing any of these scopes will be accepted.
     *
     * Example:
     *
     *      canonical_scopes: https://www.googleapis.com/auth/calendar,
     *                        https://www.googleapis.com/auth/calendar.read
     * </pre>
     *
     * <code>string canonical_scopes = 1;</code>
     *
     * @return The canonicalScopes.
     */
    public java.lang.String getCanonicalScopes() {
      java.lang.Object ref = canonicalScopes_;
      if (!(ref instanceof java.lang.String)) {
        shaded.xolir.com.google.protobuf.ByteString bs = (shaded.xolir.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        canonicalScopes_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The list of publicly documented OAuth scopes that are allowed access. An
     * OAuth token containing any of these scopes will be accepted.
     *
     * Example:
     *
     *      canonical_scopes: https://www.googleapis.com/auth/calendar,
     *                        https://www.googleapis.com/auth/calendar.read
     * </pre>
     *
     * <code>string canonical_scopes = 1;</code>
     *
     * @return The bytes for canonicalScopes.
     */
    public shaded.xolir.com.google.protobuf.ByteString getCanonicalScopesBytes() {
      java.lang.Object ref = canonicalScopes_;
      if (ref instanceof String) {
        shaded.xolir.com.google.protobuf.ByteString b =
            shaded.xolir.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        canonicalScopes_ = b;
        return b;
      } else {
        return (shaded.xolir.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The list of publicly documented OAuth scopes that are allowed access. An
     * OAuth token containing any of these scopes will be accepted.
     *
     * Example:
     *
     *      canonical_scopes: https://www.googleapis.com/auth/calendar,
     *                        https://www.googleapis.com/auth/calendar.read
     * </pre>
     *
     * <code>string canonical_scopes = 1;</code>
     *
     * @param value The canonicalScopes to set.
     * @return This builder for chaining.
     */
    public Builder setCanonicalScopes(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      canonicalScopes_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of publicly documented OAuth scopes that are allowed access. An
     * OAuth token containing any of these scopes will be accepted.
     *
     * Example:
     *
     *      canonical_scopes: https://www.googleapis.com/auth/calendar,
     *                        https://www.googleapis.com/auth/calendar.read
     * </pre>
     *
     * <code>string canonical_scopes = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCanonicalScopes() {
      canonicalScopes_ = getDefaultInstance().getCanonicalScopes();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of publicly documented OAuth scopes that are allowed access. An
     * OAuth token containing any of these scopes will be accepted.
     *
     * Example:
     *
     *      canonical_scopes: https://www.googleapis.com/auth/calendar,
     *                        https://www.googleapis.com/auth/calendar.read
     * </pre>
     *
     * <code>string canonical_scopes = 1;</code>
     *
     * @param value The bytes for canonicalScopes to set.
     * @return This builder for chaining.
     */
    public Builder setCanonicalScopesBytes(shaded.xolir.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      canonicalScopes_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final shaded.xolir.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final shaded.xolir.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.api.OAuthRequirements)
  }

  // @@protoc_insertion_point(class_scope:google.api.OAuthRequirements)
  private static final shaded.xolir.com.google.api.OAuthRequirements DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.api.OAuthRequirements();
  }

  public static shaded.xolir.com.google.api.OAuthRequirements getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final shaded.xolir.com.google.protobuf.Parser<OAuthRequirements> PARSER =
      new com.google.protobuf.AbstractParser<OAuthRequirements>() {
        @java.lang.Override
        public OAuthRequirements parsePartialFrom(
            shaded.xolir.com.google.protobuf.CodedInputStream input,
            shaded.xolir.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws shaded.xolir.com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (shaded.xolir.com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (shaded.xolir.com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static shaded.xolir.com.google.protobuf.Parser<OAuthRequirements> parser() {
    return PARSER;
  }

  @java.lang.Override
  public shaded.xolir.com.google.protobuf.Parser<OAuthRequirements> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public shaded.xolir.com.google.api.OAuthRequirements getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
