package shaded.xolir.org.checkerframework.checker.compilermsgs.qual;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import shaded.xolir.org.checkerframework.framework.qual.DefaultQualifierInHierarchy;
import shaded.xolir.org.checkerframework.framework.qual.InvisibleQualifier;
import shaded.xolir.org.checkerframework.framework.qual.SubtypeOf;

/**
 * A {@code String} that might or might not be a compiler message key.
 *
 * @checker_framework.manual #compilermsgs-checker Compiler Message Key Checker
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE_USE, ElementType.TYPE_PARAMETER})
@InvisibleQualifier
@SubtypeOf({})
@DefaultQualifierInHierarchy
public @interface UnknownCompilerMessageKey {}
