package shaded.xolir.org.checkerframework.checker.index.qual;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import shaded.xolir.org.checkerframework.framework.qual.DefaultQualifierInHierarchy;
import shaded.xolir.org.checkerframework.framework.qual.InvisibleQualifier;
import shaded.xolir.org.checkerframework.framework.qual.SubtypeOf;

/**
 * The top type for the Substring Index type system. This indicates that the Index Checker does not
 * know any sequences that this integer is a {@link SubstringIndexFor substring index} for.
 *
 * @checker_framework.manual #index-substringindex Index Checker
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE_USE, ElementType.TYPE_PARAMETER})
@SubtypeOf({})
@DefaultQualifierInHierarchy
@InvisibleQualifier
public @interface SubstringIndexUnknown {}
