package shaded.xolir.org.checkerframework.checker.signature.qual;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import shaded.xolir.org.checkerframework.framework.qual.SubtypeOf;

/**
 * The format produced by the {@link Class#getSimpleName()} method. It is an identifier or the empty
 * string (for an anonymous class), followed by an number of array square brackets.
 *
 * @checker_framework.manual #signature-checker Signature Checker
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE_USE, ElementType.TYPE_PARAMETER})
@SubtypeOf(SignatureUnknown.class)
public @interface ClassGetSimpleName {}
