package shaded.xolir.org.checkerframework.checker.signedness.qual;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import shaded.xolir.org.checkerframework.framework.qual.SubtypeOf;
import shaded.xolir.org.checkerframework.framework.qual.TargetLocations;
import shaded.xolir.org.checkerframework.framework.qual.TypeUseLocation;

/**
 * The bottom type in the Signedness type system. Programmers should rarely write this type.
 *
 * <p>This is the type of the {@code null} literal.
 *
 * @checker_framework.manual #signedness-checker Signedness Checker
 * @checker_framework.manual #bottom-type the bottom type
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE_USE, ElementType.TYPE_PARAMETER})
@TargetLocations({TypeUseLocation.EXPLICIT_LOWER_BOUND, TypeUseLocation.EXPLICIT_UPPER_BOUND})
@SubtypeOf({SignedPositive.class})
public @interface SignednessBottom {}
