/*
 * Decompiled with CFR 0.152.
 */
package shaded.xolir.com.google.common.collect;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import shaded.xolir.com.google.common.annotations.GwtCompatible;
import shaded.xolir.com.google.common.annotations.GwtIncompatible;
import shaded.xolir.com.google.common.annotations.J2ktIncompatible;
import shaded.xolir.com.google.common.base.Preconditions;
import shaded.xolir.com.google.common.collect.CollectPreconditions;
import shaded.xolir.com.google.common.collect.ElementTypesAreNonnullByDefault;
import shaded.xolir.com.google.common.collect.IgnoreJRERequirement;
import shaded.xolir.com.google.common.collect.ImmutableList;
import shaded.xolir.com.google.common.collect.ObjectArrays;
import shaded.xolir.com.google.common.collect.Platform;
import shaded.xolir.com.google.common.collect.UnmodifiableIterator;
import shaded.xolir.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shaded.xolir.com.google.errorprone.annotations.DoNotCall;
import shaded.xolir.com.google.errorprone.annotations.DoNotMock;
import shaded.xolir.javax.annotation.CheckForNull;
import shaded.xolir.org.checkerframework.checker.nullness.qual.Nullable;

@DoNotMock(value="Use ImmutableList.of or another implementation")
@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public abstract class ImmutableCollection<E>
extends AbstractCollection<E>
implements Serializable {
    static final int SPLITERATOR_CHARACTERISTICS = 1296;
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private static final long serialVersionUID = 912559L;

    ImmutableCollection() {
    }

    @Override
    public abstract UnmodifiableIterator<E> iterator();

    @Override
    @IgnoreJRERequirement
    public Spliterator<E> spliterator() {
        return Spliterators.spliterator(this, 1296);
    }

    @Override
    @J2ktIncompatible
    public final Object[] toArray() {
        return this.toArray(EMPTY_ARRAY);
    }

    @Override
    @CanIgnoreReturnValue
    public final <T> T[] toArray(T[] other) {
        Preconditions.checkNotNull(other);
        int size = this.size();
        if (other.length < size) {
            Object[] internal = this.internalArray();
            if (internal != null) {
                return Platform.copy(internal, this.internalArrayStart(), this.internalArrayEnd(), other);
            }
            other = ObjectArrays.newArray(other, size);
        } else if (other.length > size) {
            other[size] = null;
        }
        this.copyIntoArray(other, 0);
        return other;
    }

    @CheckForNull
    @Nullable Object[] internalArray() {
        return null;
    }

    int internalArrayStart() {
        throw new UnsupportedOperationException();
    }

    int internalArrayEnd() {
        throw new UnsupportedOperationException();
    }

    @Override
    public abstract boolean contains(@CheckForNull Object var1);

    @Override
    @Deprecated
    @CanIgnoreReturnValue
    @DoNotCall(value="Always throws UnsupportedOperationException")
    public final boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    @CanIgnoreReturnValue
    @DoNotCall(value="Always throws UnsupportedOperationException")
    public final boolean remove(@CheckForNull Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    @CanIgnoreReturnValue
    @DoNotCall(value="Always throws UnsupportedOperationException")
    public final boolean addAll(Collection<? extends E> newElements) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    @CanIgnoreReturnValue
    @DoNotCall(value="Always throws UnsupportedOperationException")
    public final boolean removeAll(Collection<?> oldElements) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    @CanIgnoreReturnValue
    @DoNotCall(value="Always throws UnsupportedOperationException")
    public final boolean retainAll(Collection<?> elementsToKeep) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    @DoNotCall(value="Always throws UnsupportedOperationException")
    public final void clear() {
        throw new UnsupportedOperationException();
    }

    public ImmutableList<E> asList() {
        return this.isEmpty() ? ImmutableList.of() : ImmutableList.asImmutableList(this.toArray());
    }

    abstract boolean isPartialView();

    @CanIgnoreReturnValue
    int copyIntoArray(@Nullable Object[] dst, int offset) {
        for (Object e : this) {
            dst[offset++] = e;
        }
        return offset;
    }

    @J2ktIncompatible
    @GwtIncompatible
    Object writeReplace() {
        return new ImmutableList.SerializedForm(this.toArray());
    }

    @J2ktIncompatible
    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Use SerializedForm");
    }

    static abstract class ArrayBasedBuilder<E>
    extends Builder<E> {
        @Nullable Object[] contents;
        int size;
        boolean forceCopy;

        ArrayBasedBuilder(int initialCapacity) {
            CollectPreconditions.checkNonnegative(initialCapacity, "initialCapacity");
            this.contents = new Object[initialCapacity];
            this.size = 0;
        }

        private void ensureRoomFor(int newElements) {
            @Nullable Object[] contents = this.contents;
            int newCapacity = ArrayBasedBuilder.expandedCapacity(contents.length, this.size + newElements);
            if (newCapacity > contents.length || this.forceCopy) {
                this.contents = Arrays.copyOf(this.contents, newCapacity);
                this.forceCopy = false;
            }
        }

        @Override
        @CanIgnoreReturnValue
        public ArrayBasedBuilder<E> add(E element) {
            Preconditions.checkNotNull(element);
            this.ensureRoomFor(1);
            this.contents[this.size++] = element;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<E> add(E ... elements) {
            this.addAll(elements, elements.length);
            return this;
        }

        final void addAll(@Nullable Object[] elements, int n) {
            ObjectArrays.checkElementsNotNull(elements, n);
            this.ensureRoomFor(n);
            System.arraycopy(elements, 0, this.contents, this.size, n);
            this.size += n;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<E> addAll(Iterable<? extends E> elements) {
            if (elements instanceof Collection) {
                Collection collection = (Collection)elements;
                this.ensureRoomFor(collection.size());
                if (collection instanceof ImmutableCollection) {
                    ImmutableCollection immutableCollection = (ImmutableCollection)collection;
                    this.size = immutableCollection.copyIntoArray(this.contents, this.size);
                    return this;
                }
            }
            super.addAll(elements);
            return this;
        }
    }

    @DoNotMock
    public static abstract class Builder<E> {
        static final int DEFAULT_INITIAL_CAPACITY = 4;

        static int expandedCapacity(int oldCapacity, int minCapacity) {
            if (minCapacity < 0) {
                throw new IllegalArgumentException("cannot store more than MAX_VALUE elements");
            }
            if (minCapacity <= oldCapacity) {
                return oldCapacity;
            }
            int newCapacity = oldCapacity + (oldCapacity >> 1) + 1;
            if (newCapacity < minCapacity) {
                newCapacity = Integer.highestOneBit(minCapacity - 1) << 1;
            }
            if (newCapacity < 0) {
                newCapacity = Integer.MAX_VALUE;
            }
            return newCapacity;
        }

        Builder() {
        }

        @CanIgnoreReturnValue
        public abstract Builder<E> add(E var1);

        @CanIgnoreReturnValue
        public Builder<E> add(E ... elements) {
            for (E element : elements) {
                this.add(element);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<E> addAll(Iterable<? extends E> elements) {
            for (E element : elements) {
                this.add(element);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<E> addAll(Iterator<? extends E> elements) {
            while (elements.hasNext()) {
                this.add(elements.next());
            }
            return this;
        }

        public abstract ImmutableCollection<E> build();
    }
}

