/*
 * Decompiled with CFR 0.152.
 */
package nl.martijndwars.webpush;

import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyAgreement;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import nl.martijndwars.webpush.Encrypted;
import nl.martijndwars.webpush.GcmNotification;
import nl.martijndwars.webpush.Notification;
import org.apache.http.client.fluent.Async;
import org.apache.http.client.fluent.Content;
import org.apache.http.client.fluent.Request;
import org.apache.http.entity.ContentType;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.generators.HKDFBytesGenerator;
import org.bouncycastle.crypto.params.HKDFParameters;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;

public class PushService {
    private ExecutorService threadpool = Executors.newFixedThreadPool(1);
    private String gcmApiKey;

    public PushService() {
    }

    public PushService(String gcmApiKey) {
        this.gcmApiKey = gcmApiKey;
    }

    public static Encrypted encrypt(PublicKey userPublicKey, byte[] payload) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, NoSuchPaddingException, BadPaddingException, IllegalBlockSizeException, InvalidKeySpecException {
        ECNamedCurveParameterSpec parameterSpec = ECNamedCurveTable.getParameterSpec((String)"secp256r1");
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("ECDH", "BC");
        keyPairGenerator.initialize((AlgorithmParameterSpec)parameterSpec);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        PublicKey publicKey = keyPair.getPublic();
        SecretKey secretKey = PushService.computeSecret(keyPair.getPrivate(), userPublicKey);
        byte[] salt = SecureRandom.getSeed(16);
        byte[] ciphertext = PushService.encrypt(secretKey, salt, payload);
        return new Encrypted.Builder().withPublicKey(publicKey).withSalt(salt).withCiphertext(ciphertext).build();
    }

    public static SecretKey computeSecret(PrivateKey privateKey, PublicKey publicKey) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeyException {
        KeyAgreement keyAgreement = KeyAgreement.getInstance("ECDH", "BC");
        keyAgreement.init(privateKey);
        keyAgreement.doPhase(publicKey, true);
        return keyAgreement.generateSecret("AES");
    }

    public static byte[] encrypt(SecretKey secret, byte[] salt, byte[] payload) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException, BadPaddingException, IllegalBlockSizeException {
        byte[] key = PushService.hkdfExpand(secret.getEncoded(), salt, PushService.info("aesgcm128"), 16);
        byte[] nonce = PushService.hkdfExpand(secret.getEncoded(), salt, PushService.info("nonce"), 12);
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        cipher.init(1, (Key)new SecretKeySpec(key, "AES"), new GCMParameterSpec(128, nonce));
        cipher.update(new byte[1]);
        cipher.update(payload);
        return cipher.doFinal();
    }

    protected static byte[] info(String base) {
        String prefix = "Content-Encoding: ";
        return (prefix + base).getBytes();
    }

    protected static byte[] hkdfExpand(byte[] ikm, byte[] salt, byte[] info, int length) throws InvalidKeyException, NoSuchAlgorithmException {
        HKDFBytesGenerator hkdf = new HKDFBytesGenerator((Digest)new SHA256Digest());
        hkdf.init((DerivationParameters)new HKDFParameters(ikm, salt, info));
        byte[] okm = new byte[length];
        hkdf.generateBytes(okm, 0, length);
        return okm;
    }

    public Future<Content> send(Notification notification) throws NoSuchPaddingException, InvalidKeyException, NoSuchAlgorithmException, IllegalBlockSizeException, BadPaddingException, NoSuchProviderException, InvalidAlgorithmParameterException, IOException, InvalidKeySpecException {
        Request request = Request.Post((String)notification.getEndpoint()).addHeader("TTL", String.valueOf(notification.getTTL()));
        if (notification instanceof GcmNotification) {
            if (null == this.gcmApiKey) {
                throw new IllegalStateException("GCM API key required for using Google Cloud Messaging");
            }
            GcmNotification gcmNotification = (GcmNotification)notification;
            request.addHeader("Authorization", "key=" + this.gcmApiKey).addHeader("Accept", "application/json").bodyString(gcmNotification.getBody(), ContentType.APPLICATION_JSON);
        } else {
            Encrypted encrypted = PushService.encrypt(notification.getUserPublicKey(), notification.getPayload());
            BaseEncoding encoder = BaseEncoding.base64Url();
            byte[] dh = ((BCECPublicKey)encrypted.getPublicKey()).getQ().getEncoded(false);
            byte[] salt = encrypted.getSalt();
            request.addHeader("Content-Type", "application/octet-stream").addHeader("Content-Encoding", "aesgcm128").addHeader("Encryption-Key", "keyid=p256dh;dh=" + encoder.encode(dh)).addHeader("Encryption", "keyid=p256dh;salt=" + encoder.encode(salt)).bodyByteArray(encrypted.getCiphertext());
        }
        Async async = Async.newInstance().use((Executor)this.threadpool);
        return async.execute(request);
    }
}

