/*
 * Decompiled with CFR 0.152.
 */
package nl.martijndwars.webpush;

import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import nl.martijndwars.webpush.Encrypted;
import nl.martijndwars.webpush.GcmNotification;
import nl.martijndwars.webpush.HttpEce;
import nl.martijndwars.webpush.Notification;
import nl.martijndwars.webpush.Utils;
import org.apache.http.client.fluent.Async;
import org.apache.http.client.fluent.Content;
import org.apache.http.client.fluent.Request;
import org.apache.http.entity.ContentType;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.json.JSONObject;

public class PushService {
    private ExecutorService threadpool = Executors.newFixedThreadPool(1);
    private String gcmApiKey;

    public PushService() {
    }

    public PushService(String gcmApiKey) {
        this.gcmApiKey = gcmApiKey;
    }

    public static Encrypted encrypt(byte[] buffer, PublicKey userPublicKey, byte[] userAuth, int padSize) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, NoSuchPaddingException, BadPaddingException, IllegalBlockSizeException, InvalidKeySpecException, IOException {
        ECNamedCurveParameterSpec parameterSpec = ECNamedCurveTable.getParameterSpec((String)"prime256v1");
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("ECDH", "BC");
        keyPairGenerator.initialize((AlgorithmParameterSpec)parameterSpec);
        KeyPair serverKey = keyPairGenerator.generateKeyPair();
        HashMap<String, KeyPair> keys = new HashMap<String, KeyPair>();
        keys.put("server-key-id", serverKey);
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("server-key-id", "P-256");
        byte[] salt = SecureRandom.getSeed(16);
        HttpEce httpEce = new HttpEce(keys, labels);
        byte[] ciphertext = httpEce.encrypt(buffer, salt, null, "server-key-id", userPublicKey, userAuth, padSize);
        return new Encrypted.Builder().withSalt(salt).withPublicKey(serverKey.getPublic()).withCiphertext(ciphertext).build();
    }

    public Future<Content> send(Notification notification) throws NoSuchPaddingException, InvalidKeyException, NoSuchAlgorithmException, IllegalBlockSizeException, BadPaddingException, NoSuchProviderException, InvalidAlgorithmParameterException, IOException, InvalidKeySpecException {
        BaseEncoding base64url = BaseEncoding.base64Url();
        BaseEncoding base64 = BaseEncoding.base64();
        Encrypted encrypted = PushService.encrypt(notification.getPayload(), notification.getUserPublicKey(), notification.getUserAuth(), notification.getPadSize());
        byte[] dh = Utils.savePublicKey((ECPublicKey)encrypted.getPublicKey());
        byte[] salt = encrypted.getSalt();
        Request request = Request.Post((String)notification.getEndpoint()).addHeader("TTL", String.valueOf(notification.getTTL()));
        if (notification instanceof GcmNotification) {
            if (null == this.gcmApiKey) {
                throw new IllegalStateException("GCM API key required for using Google Cloud Messaging");
            }
            String body = new JSONObject().put("registration_ids", Collections.singletonList(((GcmNotification)notification).getRegistrationId())).put("raw_data", (Object)base64.encode(encrypted.getCiphertext())).toString();
            request.addHeader("Authorization", "key=" + this.gcmApiKey).addHeader("Encryption", "keyid=p256dh;salt=" + base64url.encode(salt)).addHeader("Crypto-Key", "dh=" + base64url.encode(dh)).addHeader("Content-Encoding", "aesgcm").bodyString(body, ContentType.APPLICATION_JSON);
        } else {
            request.addHeader("Content-Type", "application/octet-stream").addHeader("Content-Encoding", "aesgcm128").addHeader("Encryption-Key", "keyid=p256dh;dh=" + base64url.omitPadding().encode(dh)).addHeader("Encryption", "keyid=p256dh;salt=" + base64url.omitPadding().encode(salt)).bodyByteArray(encrypted.getCiphertext());
        }
        Async async = Async.newInstance().use((Executor)this.threadpool);
        return async.execute(request);
    }
}

