/*
 * Decompiled with CFR 0.152.
 */
package nl.martijndwars.webpush;

import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import nl.martijndwars.webpush.Encrypted;
import nl.martijndwars.webpush.HttpEce;
import nl.martijndwars.webpush.Notification;
import nl.martijndwars.webpush.Utils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.lang.JoseException;

public class PushService {
    private String gcmApiKey;
    private String subject;
    private PublicKey publicKey;
    private Key privateKey;

    public static Encrypted encrypt(byte[] buffer, PublicKey userPublicKey, byte[] userAuth, int padSize) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, NoSuchPaddingException, BadPaddingException, IllegalBlockSizeException, InvalidKeySpecException, IOException {
        ECNamedCurveParameterSpec parameterSpec = ECNamedCurveTable.getParameterSpec((String)"prime256v1");
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("ECDH", "BC");
        keyPairGenerator.initialize((AlgorithmParameterSpec)parameterSpec);
        KeyPair serverKey = keyPairGenerator.generateKeyPair();
        HashMap<String, KeyPair> keys = new HashMap<String, KeyPair>();
        keys.put("server-key-id", serverKey);
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("server-key-id", "P-256");
        byte[] salt = SecureRandom.getSeed(16);
        HttpEce httpEce = new HttpEce(keys, labels);
        byte[] ciphertext = httpEce.encrypt(buffer, salt, null, "server-key-id", userPublicKey, userAuth, padSize);
        return new Encrypted.Builder().withSalt(salt).withPublicKey(serverKey.getPublic()).withCiphertext(ciphertext).build();
    }

    public HttpResponse send(Notification notification) throws NoSuchPaddingException, InvalidKeyException, NoSuchAlgorithmException, IllegalBlockSizeException, BadPaddingException, NoSuchProviderException, InvalidAlgorithmParameterException, IOException, InvalidKeySpecException, JoseException {
        BaseEncoding base64url = BaseEncoding.base64Url();
        Encrypted encrypted = PushService.encrypt(notification.getPayload(), notification.getUserPublicKey(), notification.getUserAuth(), notification.getPadSize());
        byte[] dh = Utils.savePublicKey((ECPublicKey)encrypted.getPublicKey());
        byte[] salt = encrypted.getSalt();
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(notification.getEndpoint());
        httpPost.addHeader("TTL", String.valueOf(notification.getTTL()));
        HashMap<String, String> headers = new HashMap<String, String>();
        if (notification.hasPayload()) {
            headers.put("Content-Type", "application/octet-stream");
            headers.put("Content-Encoding", "aesgcm");
            headers.put("Encryption", "keyid=p256dh;salt=" + base64url.omitPadding().encode(salt));
            headers.put("Crypto-Key", "keyid=p256dh;dh=" + base64url.encode(dh));
            httpPost.setEntity((HttpEntity)new ByteArrayEntity(encrypted.getCiphertext()));
        }
        if (notification.isGcm()) {
            if (this.gcmApiKey == null) {
                throw new IllegalStateException("An GCM API key is needed to send a push notification to a GCM endpint.");
            }
            headers.put("Authorization", "key=" + this.gcmApiKey);
        }
        if (this.vapidEnabled() && !notification.isGcm()) {
            JwtClaims claims = new JwtClaims();
            claims.setAudience(notification.getOrigin());
            claims.setExpirationTimeMinutesInTheFuture(720.0f);
            claims.setSubject(this.subject);
            JsonWebSignature jws = new JsonWebSignature();
            jws.setHeader("typ", "JWT");
            jws.setHeader("alg", "ES256");
            jws.setPayload(claims.toJson());
            jws.setKey(this.privateKey);
            jws.setAlgorithmHeaderValue("ES256");
            headers.put("Authorization", "Bearer " + jws.getCompactSerialization());
            byte[] pk = Utils.savePublicKey((ECPublicKey)this.publicKey);
            if (headers.containsKey("Crypto-Key")) {
                headers.put("Crypto-Key", (String)headers.get("Crypto-Key") + ";p256ecdsa=" + base64url.omitPadding().encode(pk));
            } else {
                headers.put("Crypto-Key", "p256ecdsa=" + base64url.encode(pk));
            }
        }
        for (Map.Entry entry : headers.entrySet()) {
            httpPost.addHeader((Header)new BasicHeader((String)entry.getKey(), (String)entry.getValue()));
        }
        return httpClient.execute((HttpUriRequest)httpPost);
    }

    public PushService setGcmApiKey(String gcmApiKey) {
        this.gcmApiKey = gcmApiKey;
        return this;
    }

    public PushService setSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public PushService setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
        return this;
    }

    public PushService setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    protected boolean vapidEnabled() {
        return this.publicKey != null && this.privateKey != null;
    }
}

