/*
 * Decompiled with CFR 0.152.
 */
package nl.martijndwars.webpush.cli;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import java.security.Provider;
import java.security.Security;
import nl.martijndwars.webpush.cli.commands.GenerateKeyCommand;
import nl.martijndwars.webpush.cli.commands.SendNotificationCommand;
import nl.martijndwars.webpush.cli.handlers.GenerateKeyHandler;
import nl.martijndwars.webpush.cli.handlers.SendNotificationHandler;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class Cli {
    private static final String GENERATE_KEY = "generate-key";
    private static final String SEND_NOTIFICATION = "send-notification";

    public static void main(String[] args) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        GenerateKeyCommand generateKeyCommand = new GenerateKeyCommand();
        SendNotificationCommand sendNotificationCommand = new SendNotificationCommand();
        JCommander jCommander = JCommander.newBuilder().addCommand(GENERATE_KEY, (Object)generateKeyCommand, new String[0]).addCommand(SEND_NOTIFICATION, (Object)sendNotificationCommand, new String[0]).build();
        try {
            jCommander.parse(args);
            if (jCommander.getParsedCommand() != null) {
                switch (jCommander.getParsedCommand()) {
                    case "generate-key": {
                        new GenerateKeyHandler(generateKeyCommand).run();
                        break;
                    }
                    case "send-notification": {
                        new SendNotificationHandler(sendNotificationCommand).run();
                    }
                }
            } else {
                jCommander.usage();
            }
        }
        catch (ParameterException e) {
            e.usage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

