/*
 * Decompiled with CFR 0.152.
 */
package nl.michelbijnen.jsonapi;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import nl.michelbijnen.jsonapi.JsonApiParser;
import nl.michelbijnen.jsonapi.annotation.JsonApiId;
import nl.michelbijnen.jsonapi.annotation.JsonApiLink;
import nl.michelbijnen.jsonapi.annotation.JsonApiObject;
import nl.michelbijnen.jsonapi.annotation.JsonApiProperty;
import nl.michelbijnen.jsonapi.annotation.JsonApiRelation;
import nl.michelbijnen.jsonapi.helper.GetterAndSetter;
import org.json.JSONObject;

public class JsonApiConverter {
    private final Object object;

    public JsonApiConverter(Object object) throws Exception {
        if (!object.getClass().isAnnotationPresent(JsonApiObject.class)) {
            throw new Exception("The reference @JsonApiObject isn't present in specified class");
        }
        this.object = object;
    }

    public String convert() throws Exception {
        JSONObject finalJsonObject = new JSONObject();
        finalJsonObject.put("links", (Object)this.parseToLinks());
        finalJsonObject.put("data", (Object)this.parseToData());
        return finalJsonObject.toString();
    }

    private JSONObject parseToLinks() throws Exception {
        JSONObject links = new JSONObject();
        for (Field field : this.object.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(JsonApiLink.class) || !field.getAnnotation(JsonApiLink.class).relation().equals("")) continue;
            links.put(field.getAnnotation(JsonApiLink.class).value().toString().toLowerCase(), new GetterAndSetter().callGetter(this.object, field.getName()));
        }
        return links;
    }

    private JSONObject parseToData() throws Exception {
        JSONObject data = new JSONObject();
        JSONObject relationships = new JSONObject();
        ArrayList<JSONObject> included = new ArrayList<JSONObject>();
        data.put("type", (Object)this.object.getClass().getAnnotation(JsonApiObject.class).value());
        for (Field field : this.object.getClass().getDeclaredFields()) {
            if (field.isAnnotationPresent(JsonApiId.class)) {
                data.put("id", new GetterAndSetter().callGetter(this.object, field.getName()));
                continue;
            }
            if (field.isAnnotationPresent(JsonApiProperty.class)) {
                data.put(field.getName(), new GetterAndSetter().callGetter(this.object, field.getName()));
                continue;
            }
            if (!field.isAnnotationPresent(JsonApiRelation.class)) continue;
            relationships.put(field.getAnnotation(JsonApiRelation.class).value(), (Object)JsonApiParser.parseRelationship(this.object, field));
            Object relationObject = new GetterAndSetter().callGetter(this.object, field.getName());
            if (Collection.class.isAssignableFrom(relationObject.getClass())) {
                for (Object loopRelationObject : (Collection)relationObject) {
                    included.add(JsonApiParser.parseInclude(loopRelationObject));
                }
                continue;
            }
            included.add(JsonApiParser.parseInclude(relationObject));
        }
        data.put("relationships", (Object)relationships);
        data.put("included", included);
        return data;
    }
}

