/*
 * Decompiled with CFR 0.152.
 */
package nl.michelbijnen.jsonapi;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import nl.michelbijnen.jsonapi.annotation.JsonApiId;
import nl.michelbijnen.jsonapi.annotation.JsonApiLink;
import nl.michelbijnen.jsonapi.annotation.JsonApiObject;
import nl.michelbijnen.jsonapi.annotation.JsonApiProperty;
import nl.michelbijnen.jsonapi.annotation.JsonApiRelation;
import nl.michelbijnen.jsonapi.helper.GetterAndSetter;
import org.json.JSONObject;

class JsonApiParser {
    JsonApiParser() {
    }

    static JSONObject parseToLinks(Object object) throws Exception {
        JSONObject links = new JSONObject();
        for (Field field : object.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(JsonApiLink.class) || !field.getAnnotation(JsonApiLink.class).relation().equals("")) continue;
            links.put(field.getAnnotation(JsonApiLink.class).value().toString().toLowerCase(), new GetterAndSetter().callGetter(object, field.getName()));
        }
        return links;
    }

    static JSONObject parseToData(Object object) throws Exception {
        JSONObject data = new JSONObject();
        JSONObject relationships = new JSONObject();
        JSONObject attributes = new JSONObject();
        ArrayList<JSONObject> included = new ArrayList<JSONObject>();
        data.put("type", (Object)object.getClass().getAnnotation(JsonApiObject.class).value());
        for (Field field : object.getClass().getDeclaredFields()) {
            if (field.isAnnotationPresent(JsonApiId.class)) {
                data.put("id", new GetterAndSetter().callGetter(object, field.getName()));
                continue;
            }
            if (field.isAnnotationPresent(JsonApiProperty.class)) {
                attributes.put(field.getName(), new GetterAndSetter().callGetter(object, field.getName()));
                continue;
            }
            if (!field.isAnnotationPresent(JsonApiRelation.class)) continue;
            relationships.put(field.getAnnotation(JsonApiRelation.class).value(), (Object)JsonApiParser.parseRelationship(object, field));
            Object relationObject = new GetterAndSetter().callGetter(object, field.getName());
            if (Collection.class.isAssignableFrom(relationObject.getClass())) {
                for (Object loopRelationObject : (Collection)relationObject) {
                    included.add(JsonApiParser.parseInclude(loopRelationObject));
                }
                continue;
            }
            included.add(JsonApiParser.parseInclude(relationObject));
        }
        data.put("attributes", (Object)attributes);
        data.put("relationships", (Object)relationships);
        data.put("included", included);
        return data;
    }

    static JSONObject parseRelationship(Object object, Field field) throws Exception {
        JSONObject relationship = new JSONObject();
        JSONObject links = new JSONObject();
        for (Field relationField : object.getClass().getDeclaredFields()) {
            if (!relationField.isAnnotationPresent(JsonApiLink.class) || !relationField.getAnnotation(JsonApiLink.class).relation().equals(field.getAnnotation(JsonApiRelation.class).value())) continue;
            links.put(relationField.getAnnotation(JsonApiLink.class).value().toString().toLowerCase(), new GetterAndSetter().callGetter(object, relationField.getName()));
        }
        if (Collection.class.isAssignableFrom(field.getType())) {
            ArrayList<JSONObject> dataForEach = new ArrayList<JSONObject>();
            for (Object relationObject : (Collection)new GetterAndSetter().callGetter(object, field.getName())) {
                JSONObject dataObjectForEach = new JSONObject();
                dataObjectForEach.put("type", (Object)relationObject.getClass().getAnnotation(JsonApiObject.class).value());
                for (Field relationField : relationObject.getClass().getDeclaredFields()) {
                    if (!relationField.isAnnotationPresent(JsonApiId.class)) continue;
                    dataObjectForEach.put("id", new GetterAndSetter().callGetter(relationObject, relationField.getName()));
                    break;
                }
                dataForEach.add(dataObjectForEach);
            }
            relationship.put("data", dataForEach);
        } else {
            Object relationObject = new GetterAndSetter().callGetter(object, field.getName());
            JSONObject data = new JSONObject();
            data.put("type", (Object)relationObject.getClass().getAnnotation(JsonApiObject.class).value());
            for (Field relationField : relationObject.getClass().getDeclaredFields()) {
                if (!relationField.isAnnotationPresent(JsonApiId.class)) continue;
                data.put("id", new GetterAndSetter().callGetter(relationObject, relationField.getName()));
                break;
            }
            relationship.put("data", (Object)data);
        }
        relationship.put("links", (Object)links);
        return relationship;
    }

    static JSONObject parseInclude(Object object) throws Exception {
        JSONObject include = new JSONObject();
        JSONObject attributes = new JSONObject();
        JSONObject links = new JSONObject();
        JSONObject relationship = new JSONObject();
        include.put("type", (Object)object.getClass().getAnnotation(JsonApiObject.class).value());
        for (Field relationField : object.getClass().getDeclaredFields()) {
            if (relationField.isAnnotationPresent(JsonApiId.class)) {
                include.put("id", new GetterAndSetter().callGetter(object, relationField.getName()));
            }
            if (relationField.isAnnotationPresent(JsonApiProperty.class)) {
                attributes.put(relationField.getName(), new GetterAndSetter().callGetter(object, relationField.getName()));
            }
            if (relationField.isAnnotationPresent(JsonApiRelation.class)) {
                JSONObject parsedRelationship = JsonApiParser.parseRelationship(object, relationField);
                parsedRelationship.remove("links");
                relationship.put(relationField.getName(), (Object)parsedRelationship);
            }
            if (!relationField.isAnnotationPresent(JsonApiLink.class)) continue;
            links.put(relationField.getAnnotation(JsonApiLink.class).value().toString().toLowerCase(), new GetterAndSetter().callGetter(object, relationField.getName()));
        }
        include.put("relationships", (Object)relationship);
        include.put("attributes", (Object)attributes);
        include.put("links", (Object)links);
        return include;
    }
}

