/*
 * Decompiled with CFR 0.152.
 */
package nl.michelbijnen.jsonapi.parser;

import java.util.Collection;
import nl.michelbijnen.jsonapi.parser.DataParser;
import nl.michelbijnen.jsonapi.parser.IncludedParser;
import nl.michelbijnen.jsonapi.parser.LinksParser;
import org.json.JSONArray;
import org.json.JSONObject;

class JsonApiParser {
    private LinksParser linksParser = new LinksParser();
    private DataParser dataParser = new DataParser();
    private IncludedParser includedParser = new IncludedParser();

    JsonApiParser() {
    }

    JSONObject parse(Object object, int maxDepth) {
        if (this.isList(object)) {
            return this.convertObjectAsList(object, maxDepth);
        }
        return this.convertObjectAsObject(object, maxDepth);
    }

    private JSONObject convertObjectAsList(Object object, int maxDepth) {
        JSONObject jsonObject = new JSONObject();
        if (((Collection)object).size() == 0) {
            jsonObject.put("data", (Object)new JSONObject());
            return jsonObject;
        }
        Object linksObject = ((Collection)object).iterator().next();
        jsonObject.put("links", (Object)this.linksParser.parse(linksObject));
        JSONArray dataJsonArray = new JSONArray();
        for (Object loopObject : (Collection)object) {
            dataJsonArray.put((Object)this.dataParser.parse(loopObject));
        }
        jsonObject.put("data", (Object)dataJsonArray);
        JSONArray includedJsonArray = new JSONArray();
        for (Object loopObject : (Collection)object) {
            for (Object includedObject : this.includedParser.parse(loopObject, maxDepth)) {
                includedJsonArray.put(includedObject);
            }
        }
        jsonObject.put("included", (Object)includedJsonArray);
        return jsonObject;
    }

    private JSONObject convertObjectAsObject(Object object, int maxDepth) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", (Object)this.dataParser.parse(object));
        jsonObject.put("links", (Object)this.linksParser.parse(object));
        jsonObject.put("included", (Object)this.includedParser.parse(object, maxDepth));
        return jsonObject;
    }

    private boolean isList(Object object) {
        return Collection.class.isAssignableFrom(object.getClass());
    }
}

