/*
 * Decompiled with CFR 0.152.
 */
package nl.michelbijnen.jsonapi.parser;

import java.lang.reflect.Field;
import java.util.Collection;
import nl.michelbijnen.jsonapi.annotation.JsonApiRelation;
import nl.michelbijnen.jsonapi.helper.GetterAndSetter;
import nl.michelbijnen.jsonapi.parser.DataParser;
import nl.michelbijnen.jsonapi.parser.LinksParser;
import org.json.JSONArray;
import org.json.JSONObject;

class RelationshipParser {
    private DataParser dataParser = new DataParser();
    private LinksParser linksParser = new LinksParser();

    RelationshipParser() {
    }

    JSONObject parse(Object object) {
        JSONObject jsonObject = new JSONObject();
        for (Field field : object.getClass().getDeclaredFields()) {
            Object relationObject;
            if (!field.isAnnotationPresent(JsonApiRelation.class) || (relationObject = GetterAndSetter.callGetter(object, field.getName())) == null) continue;
            if (this.isList(relationObject)) {
                jsonObject.put(field.getAnnotation(JsonApiRelation.class).value(), (Object)this.parseRelationshipAsList(object, field));
                continue;
            }
            jsonObject.put(field.getAnnotation(JsonApiRelation.class).value(), (Object)this.parseRelationshipAsObject(object, field));
        }
        return jsonObject;
    }

    private JSONObject parseRelationshipAsObject(Object object, Field field) {
        JSONObject relationship = new JSONObject();
        Object relationObject = GetterAndSetter.callGetter(object, field.getName());
        relationship.put("links", (Object)this.linksParser.parse(relationObject));
        relationship.put("data", (Object)this.dataParser.parse(relationObject, true));
        return relationship;
    }

    private JSONObject parseRelationshipAsList(Object object, Field field) {
        JSONObject relationship = new JSONObject();
        Collection relationObjectCollection = (Collection)GetterAndSetter.callGetter(object, field.getName());
        relationship.put("links", (Object)this.linksParser.parse(relationObjectCollection));
        JSONArray dataForEach = new JSONArray();
        for (Object relationObject : relationObjectCollection) {
            dataForEach.put((Object)this.dataParser.parse(relationObject, true));
        }
        relationship.put("data", (Object)dataForEach);
        return relationship;
    }

    private boolean isList(Object object) {
        return Collection.class.isAssignableFrom(object.getClass());
    }
}

