/*
 * Decompiled with CFR 0.152.
 */
package nl.michelbijnen.jsonapi.generator;

import nl.michelbijnen.jsonapi.annotation.JsonApiId;
import nl.michelbijnen.jsonapi.annotation.JsonApiLink;
import nl.michelbijnen.jsonapi.enumeration.JsonApiLinkType;
import nl.michelbijnen.jsonapi.exception.JsonApiException;

public abstract class JsonApiDtoExtendable {
    @JsonApiId
    private String id;
    @JsonApiLink
    private String selfRel;
    @JsonApiLink(value=JsonApiLinkType.ALL_SELF)
    private String allSelfRel;
    @JsonApiLink(value=JsonApiLinkType.FIRST)
    private String firstRel;
    @JsonApiLink(value=JsonApiLinkType.LAST)
    private String lastRel;
    @JsonApiLink(value=JsonApiLinkType.NEXT)
    private String nextRel;
    @JsonApiLink(value=JsonApiLinkType.PREVIOUS)
    private String previousRel;
    @JsonApiLink(value=JsonApiLinkType.RELATED)
    private String relatedRel;

    public void generate(String self, String all) {
        if (this.id == null || this.id.isEmpty()) {
            throw new JsonApiException("Id not entered");
        }
        String baseUrl = System.getProperty("jsonapi.baseUrl", "http://localhost:8080");
        if (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        if (!self.startsWith("/")) {
            self = "/" + self;
        }
        if (!all.startsWith("/")) {
            all = "/" + all;
        }
        if (!self.endsWith("/")) {
            self = self + "/";
        }
        this.selfRel = baseUrl + self + this.id;
        this.allSelfRel = baseUrl + all;
    }

    public String getSelfRel() {
        return this.selfRel;
    }

    public String getFirstRel() {
        return this.firstRel;
    }

    public String getLastRel() {
        return this.lastRel;
    }

    public String getNextRel() {
        return this.nextRel;
    }

    public String getPreviousRel() {
        return this.previousRel;
    }

    public String getRelatedRel() {
        return this.relatedRel;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getAllSelfRel() {
        return this.allSelfRel;
    }

    public void setSelfRel(String selfRel) {
        this.selfRel = selfRel;
    }

    public void setAllSelfRel(String allSelfRel) {
        this.allSelfRel = allSelfRel;
    }

    public void setFirstRel(String firstRel) {
        this.firstRel = firstRel;
    }

    public void setLastRel(String lastRel) {
        this.lastRel = lastRel;
    }

    public void setNextRel(String nextRel) {
        this.nextRel = nextRel;
    }

    public void setPreviousRel(String previousRel) {
        this.previousRel = previousRel;
    }

    public void setRelatedRel(String relatedRel) {
        this.relatedRel = relatedRel;
    }
}

