/*
 * Decompiled with CFR 0.152.
 */
package nl.michelbijnen.jsonapi.parser;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.stream.Stream;
import nl.michelbijnen.jsonapi.annotation.JsonApiId;
import nl.michelbijnen.jsonapi.annotation.JsonApiObject;
import nl.michelbijnen.jsonapi.exception.JsonApiException;
import nl.michelbijnen.jsonapi.helper.GetterAndSetter;
import nl.michelbijnen.jsonapi.parser.AttributesParser;
import nl.michelbijnen.jsonapi.parser.RelationshipParser;
import org.json.JSONObject;

class DataParser {
    DataParser() {
    }

    JSONObject parse(Object object) {
        return this.parse(object, false);
    }

    JSONObject parse(Object object, boolean asRelation) {
        JSONObject data = new JSONObject();
        data.put("type", (Object)this.getType(object));
        data.put("id", (Object)this.getId(object));
        if (asRelation) {
            return data;
        }
        AttributesParser attributesParser = new AttributesParser();
        data.put("attributes", (Object)attributesParser.parse(object));
        JSONObject parsedRelationships = new RelationshipParser().parse(object);
        if (!parsedRelationships.isEmpty()) {
            data.put("relationships", (Object)parsedRelationships);
        }
        return data;
    }

    private String getType(Object object) {
        if (object.getClass().getAnnotation(JsonApiObject.class) != null) {
            return object.getClass().getAnnotation(JsonApiObject.class).value();
        }
        throw new JsonApiException("@JsonApiObject(\"<classname>\") missing");
    }

    private String getId(Object object) {
        Field[] allFields;
        for (Field field : allFields = (Field[])Stream.concat(Arrays.stream(object.getClass().getDeclaredFields()), Arrays.stream(object.getClass().getSuperclass().getDeclaredFields())).toArray(Field[]::new)) {
            if (!field.isAnnotationPresent(JsonApiId.class)) continue;
            return GetterAndSetter.callGetter(object, field.getName()).toString();
        }
        throw new JsonApiException("No field with @JsonApiId is found");
    }
}

