/*
 * Decompiled with CFR 0.152.
 */
package nl.michelbijnen.jsonapi.parser;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Stream;
import nl.michelbijnen.jsonapi.annotation.JsonApiId;
import nl.michelbijnen.jsonapi.annotation.JsonApiObject;
import nl.michelbijnen.jsonapi.annotation.JsonApiRelation;
import nl.michelbijnen.jsonapi.helper.GetterAndSetter;
import nl.michelbijnen.jsonapi.parser.DataParser;
import nl.michelbijnen.jsonapi.parser.LinksParser;
import org.json.JSONArray;
import org.json.JSONObject;

class IncludedParser {
    private DataParser dataParser = new DataParser();
    private LinksParser linksParser = new LinksParser();

    IncludedParser() {
    }

    JSONArray parse(Object object, int maxDepth) {
        return this.parse(object, new JSONArray(), maxDepth, 0);
    }

    JSONArray parse(Object object, JSONArray includeArray, int maxDepth, int currentDepth) {
        if (currentDepth == maxDepth) {
            return includeArray;
        }
        if (!(object instanceof Iterable)) {
            this.parseObject(object, includeArray, maxDepth, currentDepth);
            return includeArray;
        }
        Iterable collection = (Iterable)object;
        for (Object item : collection) {
            this.parseObject(item, includeArray, maxDepth, currentDepth);
        }
        return includeArray;
    }

    private void parseObject(Object object, JSONArray includeArray, int maxDepth, int currentDepth) {
        for (Field relationField : object.getClass().getDeclaredFields()) {
            Object childRelationObject;
            if (!relationField.isAnnotationPresent(JsonApiRelation.class) || (childRelationObject = GetterAndSetter.callGetter(object, relationField.getName())) == null) continue;
            if (this.isList(childRelationObject)) {
                if (((Collection)childRelationObject).isEmpty()) continue;
                for (Object childRelationObjectAsItem : (Collection)childRelationObject) {
                    this.addObjectToIncludeArray(includeArray, childRelationObjectAsItem);
                    this.parse(childRelationObject, includeArray, maxDepth, currentDepth + 1);
                }
                continue;
            }
            this.addObjectToIncludeArray(includeArray, childRelationObject);
            this.parse(childRelationObject, includeArray, maxDepth, currentDepth + 1);
        }
    }

    private boolean addObjectToIncludeArray(JSONArray includeArray, Object relationObject) {
        if (this.rootElementExists(includeArray, relationObject)) {
            return false;
        }
        JSONObject singleIncludeObject = this.dataParser.parse(relationObject);
        singleIncludeObject.put("links", (Object)this.linksParser.parse(relationObject));
        includeArray.put((Object)singleIncludeObject);
        return true;
    }

    private boolean rootElementExists(JSONArray includeArray, Object relationObject) {
        Field[] allFields;
        for (Field insideRelationField : allFields = (Field[])Stream.concat(Arrays.stream(relationObject.getClass().getDeclaredFields()), Arrays.stream(relationObject.getClass().getSuperclass().getDeclaredFields())).toArray(Field[]::new)) {
            String type;
            String id;
            if (!insideRelationField.isAnnotationPresent(JsonApiId.class) || !this.idInIncludedArray(includeArray, id = String.valueOf(GetterAndSetter.callGetter(relationObject, insideRelationField.getName())), type = relationObject.getClass().getAnnotation(JsonApiObject.class).value())) continue;
            return true;
        }
        return false;
    }

    private boolean idInIncludedArray(JSONArray includeArray, String id, String type) {
        for (int i = 0; i < includeArray.length(); ++i) {
            JSONObject rootObjectInclude = includeArray.getJSONObject(i);
            if (!rootObjectInclude.getString("id").equals(id) || !rootObjectInclude.getString("type").equals(type)) continue;
            return true;
        }
        return false;
    }

    private boolean isList(Object object) {
        return Collection.class.isAssignableFrom(object.getClass());
    }
}

