/*
 * Decompiled with CFR 0.152.
 */
package nl.michelbijnen.jsonapi.parser;

import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Stream;
import nl.michelbijnen.jsonapi.annotation.JsonApiLink;
import nl.michelbijnen.jsonapi.enumeration.JsonApiLinkType;
import nl.michelbijnen.jsonapi.helper.GetterAndSetter;
import org.json.JSONObject;

class LinksParser {
    LinksParser() {
    }

    JSONObject parse(Object object) {
        Field[] allFields;
        JSONObject links = new JSONObject();
        boolean asList = this.isList(object);
        if (asList) {
            if (((Collection)object).size() == 0) {
                return links;
            }
            object = ((Collection)object).iterator().next();
        }
        for (Field field : allFields = (Field[])Stream.concat(Arrays.stream(object.getClass().getDeclaredFields()), Arrays.stream(object.getClass().getSuperclass().getDeclaredFields())).toArray(Field[]::new)) {
            Object href;
            if (!field.isAnnotationPresent(JsonApiLink.class)) continue;
            if (field.getAnnotation(JsonApiLink.class).value().equals((Object)JsonApiLinkType.ALL_SELF)) {
                if (!asList || !this.isValidUrl(href = GetterAndSetter.callGetter(object, field.getName()))) continue;
                links.put(JsonApiLinkType.SELF.toString().toLowerCase(), href);
                continue;
            }
            if (field.getAnnotation(JsonApiLink.class).value().equals((Object)JsonApiLinkType.SELF)) {
                if (asList || !this.isValidUrl(href = GetterAndSetter.callGetter(object, field.getName()))) continue;
                links.put(field.getAnnotation(JsonApiLink.class).value().toString().toLowerCase(), href);
                continue;
            }
            href = GetterAndSetter.callGetter(object, field.getName());
            if (!this.isValidUrl(href)) continue;
            links.put(field.getAnnotation(JsonApiLink.class).value().toString().toLowerCase(), href);
        }
        return links;
    }

    private boolean isList(Object object) {
        return Collection.class.isAssignableFrom(object.getClass());
    }

    private boolean isValidUrl(Object urlToCheckO) {
        if (urlToCheckO == null) {
            return false;
        }
        String urlToCheck = urlToCheckO.toString();
        if (urlToCheck.isEmpty()) {
            return false;
        }
        try {
            new URL(urlToCheck);
            return true;
        }
        catch (MalformedURLException e) {
            System.out.println("Warning: invalid url not added - " + urlToCheck);
            return false;
        }
    }
}

