/*
 * Decompiled with CFR 0.152.
 */
package nl.michelbijnen.jsonapi.parser;

import java.lang.reflect.Field;
import java.util.Collection;
import nl.michelbijnen.jsonapi.annotation.JsonApiRelation;
import nl.michelbijnen.jsonapi.helper.GetterAndSetter;
import nl.michelbijnen.jsonapi.parser.DataParser;
import nl.michelbijnen.jsonapi.parser.LinksParser;
import org.json.JSONArray;
import org.json.JSONObject;

class RelationshipParser {
    private DataParser dataParser = new DataParser();
    private LinksParser linksParser = new LinksParser();

    RelationshipParser() {
    }

    JSONObject parse(Object object) {
        JSONObject jsonObject = new JSONObject();
        for (Field field : object.getClass().getDeclaredFields()) {
            JSONObject relation;
            Object relationObject;
            if (!field.isAnnotationPresent(JsonApiRelation.class) || (relationObject = GetterAndSetter.callGetter(object, field.getName())) == null || (relation = this.isList(relationObject) ? this.parseRelationshipAsList(object, field) : this.parseRelationshipAsObject(object, field)).isEmpty()) continue;
            jsonObject.put(field.getAnnotation(JsonApiRelation.class).value(), (Object)relation);
        }
        return jsonObject;
    }

    private JSONObject parseRelationshipAsObject(Object object, Field field) {
        JSONObject dataParser;
        JSONObject relationship = new JSONObject();
        Object relationObject = GetterAndSetter.callGetter(object, field.getName());
        JSONObject linksParser = this.linksParser.parse(relationObject);
        if (!linksParser.isEmpty()) {
            relationship.put("links", (Object)linksParser);
        }
        if (!(dataParser = this.dataParser.parse(relationObject, true)).isEmpty()) {
            relationship.put("data", (Object)dataParser);
        }
        return relationship;
    }

    private JSONObject parseRelationshipAsList(Object object, Field field) {
        JSONObject relationship = new JSONObject();
        Collection relationObjectCollection = (Collection)GetterAndSetter.callGetter(object, field.getName());
        JSONObject linksParser = this.linksParser.parse(relationObjectCollection);
        if (!linksParser.isEmpty()) {
            relationship.put("links", (Object)linksParser);
        }
        JSONArray dataForEach = new JSONArray();
        for (Object relationObject : relationObjectCollection) {
            dataForEach.put((Object)this.dataParser.parse(relationObject, true));
        }
        if (!dataForEach.isEmpty()) {
            relationship.put("data", (Object)dataForEach);
        }
        return relationship;
    }

    private boolean isList(Object object) {
        return Collection.class.isAssignableFrom(object.getClass());
    }
}

