/*
 * Decompiled with CFR 0.152.
 */
package nl.nlighten.prometheus.tomcat;

import io.prometheus.client.Collector;
import io.prometheus.client.GaugeMetricFamily;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class TomcatDbcp2PoolExports
extends Collector {
    private static final Log log = LogFactory.getLog(TomcatDbcp2PoolExports.class);

    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            ObjectName filterName = new ObjectName("Tomcat:class=javax.sql.DataSource,type=DataSource,*");
            Set<ObjectInstance> mBeans = server.queryMBeans(filterName, null);
            if (mBeans.size() > 0) {
                List<String> labelList = Arrays.asList("pool", "context");
                GaugeMetricFamily maxActiveConnectionsGauge = new GaugeMetricFamily("tomcat_dbcp2_connections_max", "Maximum number of active connections that can be allocated from this pool at the same time", labelList);
                GaugeMetricFamily activeConnectionsGauge = new GaugeMetricFamily("tomcat_dbcp2_connections_active_total", "Number of active connections allocated from this pool", labelList);
                GaugeMetricFamily idleConnectionsGauge = new GaugeMetricFamily("tomcat_dbcp2_connections_idle_total", "Number of idle connections in this pool", labelList);
                String[] poolAttributes = new String[]{"maxTotal", "numActive", "numIdle"};
                for (ObjectInstance mBean : mBeans) {
                    if (mBean.getObjectName().getKeyProperty("connectionpool") != null) continue;
                    List<String> labelValueList = Arrays.asList(mBean.getObjectName().getKeyProperty("name").replaceAll("[\"\\\\]", ""), mBean.getObjectName().getKeyProperty("context"));
                    if (mBean.getObjectName().getKeyProperty("connections") != null) continue;
                    AttributeList attributeList = server.getAttributes(mBean.getObjectName(), poolAttributes);
                    for (Attribute attribute : attributeList.asList()) {
                        switch (attribute.getName()) {
                            case "maxTotal": {
                                maxActiveConnectionsGauge.addMetric(labelValueList, ((Integer)attribute.getValue()).doubleValue());
                                mfs.add((Collector.MetricFamilySamples)maxActiveConnectionsGauge);
                                break;
                            }
                            case "numActive": {
                                activeConnectionsGauge.addMetric(labelValueList, ((Integer)attribute.getValue()).doubleValue());
                                mfs.add((Collector.MetricFamilySamples)activeConnectionsGauge);
                                break;
                            }
                            case "numIdle": {
                                idleConnectionsGauge.addMetric(labelValueList, ((Integer)attribute.getValue()).doubleValue());
                                mfs.add((Collector.MetricFamilySamples)idleConnectionsGauge);
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Error retrieving metric:" + e.getMessage()));
        }
        return mfs;
    }

    public static boolean isDbcp2Used() {
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            ObjectName filterName = new ObjectName("tomcat.jdbc:class=org.apache.tomcat.jdbc.pool.DataSource,type=ConnectionPool,*");
            Set<ObjectInstance> mBeans = server.queryMBeans(filterName, null);
            return !mBeans.isEmpty();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

