/*
 * Decompiled with CFR 0.152.
 */
package nl.nlighten.prometheus.tomcat;

import io.prometheus.client.Collector;
import io.prometheus.client.CounterMetricFamily;
import io.prometheus.client.GaugeMetricFamily;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.catalina.util.ServerInfo;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class TomcatGenericExports
extends Collector {
    private static final Log log = LogFactory.getLog(TomcatGenericExports.class);
    private String jmxDomain = "Catalina";

    public TomcatGenericExports(boolean embedded) {
        if (embedded) {
            this.jmxDomain = "Tomcat";
        }
    }

    private void addRequestProcessorMetrics(List<Collector.MetricFamilySamples> mfs) {
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            ObjectName filterName = new ObjectName(this.jmxDomain + ":type=GlobalRequestProcessor,name=*");
            Set<ObjectInstance> mBeans = server.queryMBeans(filterName, null);
            if (mBeans.size() > 0) {
                List<String> labelNameList = Collections.singletonList("name");
                GaugeMetricFamily requestProcessorBytesReceivedGauge = new GaugeMetricFamily("tomcat_requestprocessor_received_bytes", "Number of bytes received by this request processor", labelNameList);
                GaugeMetricFamily requestProcessorBytesSentGauge = new GaugeMetricFamily("tomcat_requestprocessor_sent_bytes", "Number of bytes sent by this request processor", labelNameList);
                GaugeMetricFamily requestProcessorProcessingTimeGauge = new GaugeMetricFamily("tomcat_requestprocessor_time_seconds", "The total time spend by this request processor", labelNameList);
                CounterMetricFamily requestProcessorErrorCounter = new CounterMetricFamily("tomcat_requestprocessor_error_count", "The number of error request served by this request processor", labelNameList);
                CounterMetricFamily requestProcessorRequestCounter = new CounterMetricFamily("tomcat_requestprocessor_request_count", "The number of request served by this request processor", labelNameList);
                for (ObjectInstance mBean : mBeans) {
                    List<String> labelValueList = Collections.singletonList(mBean.getObjectName().getKeyProperty("name").replaceAll("[\"\\\\]", ""));
                    requestProcessorBytesReceivedGauge.addMetric(labelValueList, ((Long)server.getAttribute(mBean.getObjectName(), "bytesReceived")).doubleValue());
                    requestProcessorBytesSentGauge.addMetric(labelValueList, ((Long)server.getAttribute(mBean.getObjectName(), "bytesSent")).doubleValue());
                    requestProcessorProcessingTimeGauge.addMetric(labelValueList, ((Long)server.getAttribute(mBean.getObjectName(), "processingTime")).doubleValue() / 1000.0);
                    requestProcessorErrorCounter.addMetric(labelValueList, ((Integer)server.getAttribute(mBean.getObjectName(), "errorCount")).doubleValue());
                    requestProcessorRequestCounter.addMetric(labelValueList, ((Integer)server.getAttribute(mBean.getObjectName(), "requestCount")).doubleValue());
                }
                mfs.add((Collector.MetricFamilySamples)requestProcessorBytesReceivedGauge);
                mfs.add((Collector.MetricFamilySamples)requestProcessorBytesSentGauge);
                mfs.add((Collector.MetricFamilySamples)requestProcessorProcessingTimeGauge);
                mfs.add((Collector.MetricFamilySamples)requestProcessorRequestCounter);
                mfs.add((Collector.MetricFamilySamples)requestProcessorErrorCounter);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error retrieving metric.", (Throwable)e);
        }
    }

    private void addSessionMetrics(List<Collector.MetricFamilySamples> mfs) {
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            ObjectName filterName = new ObjectName(this.jmxDomain + ":type=Manager,context=*,host=*");
            Set<ObjectInstance> mBeans = server.queryMBeans(filterName, null);
            if (mBeans.size() > 0) {
                List<String> labelNameList = Arrays.asList("host", "context");
                GaugeMetricFamily activeSessionCountGauge = new GaugeMetricFamily("tomcat_session_active_total", "Number of active sessions", labelNameList);
                GaugeMetricFamily rejectedSessionCountGauge = new GaugeMetricFamily("tomcat_session_rejected_total", "Number of sessions rejected due to maxActive being reached", labelNameList);
                GaugeMetricFamily createdSessionCountGauge = new GaugeMetricFamily("tomcat_session_created_total", "Number of sessions created", labelNameList);
                GaugeMetricFamily expiredSessionCountGauge = new GaugeMetricFamily("tomcat_session_expired_total", "Number of sessions that expired", labelNameList);
                GaugeMetricFamily sessionAvgAliveTimeGauge = new GaugeMetricFamily("tomcat_session_alivetime_seconds_avg", "Average time an expired session had been alive", labelNameList);
                GaugeMetricFamily sessionMaxAliveTimeGauge = new GaugeMetricFamily("tomcat_session_alivetime_seconds_max", "Maximum time an expired session had been alive", labelNameList);
                GaugeMetricFamily contextStateGauge = new GaugeMetricFamily("tomcat_context_state_started", "Indication if the lifecycle state of this context is STARTED", labelNameList);
                for (ObjectInstance mBean : mBeans) {
                    List<String> labelValueList = Arrays.asList(mBean.getObjectName().getKeyProperty("host"), mBean.getObjectName().getKeyProperty("context"));
                    activeSessionCountGauge.addMetric(labelValueList, ((Integer)server.getAttribute(mBean.getObjectName(), "activeSessions")).doubleValue());
                    rejectedSessionCountGauge.addMetric(labelValueList, ((Integer)server.getAttribute(mBean.getObjectName(), "rejectedSessions")).doubleValue());
                    createdSessionCountGauge.addMetric(labelValueList, ((Long)server.getAttribute(mBean.getObjectName(), "sessionCounter")).doubleValue());
                    expiredSessionCountGauge.addMetric(labelValueList, ((Long)server.getAttribute(mBean.getObjectName(), "expiredSessions")).doubleValue());
                    sessionAvgAliveTimeGauge.addMetric(labelValueList, ((Integer)server.getAttribute(mBean.getObjectName(), "sessionAverageAliveTime")).doubleValue());
                    sessionMaxAliveTimeGauge.addMetric(labelValueList, ((Integer)server.getAttribute(mBean.getObjectName(), "sessionMaxAliveTime")).doubleValue());
                    if (server.getAttribute(mBean.getObjectName(), "stateName").equals("STARTED")) {
                        contextStateGauge.addMetric(labelValueList, 1.0);
                        continue;
                    }
                    contextStateGauge.addMetric(labelValueList, 0.0);
                }
                mfs.add((Collector.MetricFamilySamples)activeSessionCountGauge);
                mfs.add((Collector.MetricFamilySamples)rejectedSessionCountGauge);
                mfs.add((Collector.MetricFamilySamples)createdSessionCountGauge);
                mfs.add((Collector.MetricFamilySamples)expiredSessionCountGauge);
                mfs.add((Collector.MetricFamilySamples)sessionAvgAliveTimeGauge);
                mfs.add((Collector.MetricFamilySamples)sessionMaxAliveTimeGauge);
                mfs.add((Collector.MetricFamilySamples)contextStateGauge);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error retrieving metric.", (Throwable)e);
        }
    }

    private void addThreadPoolMetrics(List<Collector.MetricFamilySamples> mfs) {
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            ObjectName filterName = new ObjectName(this.jmxDomain + ":type=ThreadPool,name=*");
            Set<ObjectInstance> mBeans = server.queryMBeans(filterName, null);
            if (mBeans.size() > 0) {
                List<String> labelList = Collections.singletonList("name");
                GaugeMetricFamily threadPoolCurrentCountGauge = new GaugeMetricFamily("tomcat_threads_total", "Number threads in this pool.", labelList);
                GaugeMetricFamily threadPoolActiveCountGauge = new GaugeMetricFamily("tomcat_threads_active_total", "Number of active threads in this pool.", labelList);
                GaugeMetricFamily threadPoolMaxThreadsGauge = new GaugeMetricFamily("tomcat_threads_max", "Maximum number of threads allowed in this pool.", labelList);
                GaugeMetricFamily threadPoolConnectionCountGauge = new GaugeMetricFamily("tomcat_connections_active_total", "Number of connections served by this pool.", labelList);
                GaugeMetricFamily threadPoolMaxConnectionGauge = new GaugeMetricFamily("tomcat_connections_active_max", "Maximum number of concurrent connections served by this pool.", labelList);
                String[] genericAttributes = new String[]{"currentThreadCount", "currentThreadsBusy", "maxThreads", "connectionCount", "maxConnections"};
                for (ObjectInstance mBean : mBeans) {
                    List<String> labelValueList = Collections.singletonList(mBean.getObjectName().getKeyProperty("name").replaceAll("[\"\\\\]", ""));
                    AttributeList attributeList = server.getAttributes(mBean.getObjectName(), genericAttributes);
                    for (Attribute attribute : attributeList.asList()) {
                        switch (attribute.getName()) {
                            case "currentThreadCount": {
                                threadPoolCurrentCountGauge.addMetric(labelValueList, ((Integer)attribute.getValue()).doubleValue());
                                break;
                            }
                            case "currentThreadsBusy": {
                                threadPoolActiveCountGauge.addMetric(labelValueList, ((Integer)attribute.getValue()).doubleValue());
                                break;
                            }
                            case "maxThreads": {
                                threadPoolMaxThreadsGauge.addMetric(labelValueList, ((Integer)attribute.getValue()).doubleValue());
                                break;
                            }
                            case "connectionCount": {
                                threadPoolConnectionCountGauge.addMetric(labelValueList, ((Long)attribute.getValue()).doubleValue());
                                break;
                            }
                            case "maxConnections": {
                                threadPoolMaxConnectionGauge.addMetric(labelValueList, ((Integer)attribute.getValue()).doubleValue());
                            }
                        }
                    }
                }
                this.addNonEmptyMetricFamily(mfs, threadPoolCurrentCountGauge);
                this.addNonEmptyMetricFamily(mfs, threadPoolActiveCountGauge);
                this.addNonEmptyMetricFamily(mfs, threadPoolMaxThreadsGauge);
                this.addNonEmptyMetricFamily(mfs, threadPoolConnectionCountGauge);
                this.addNonEmptyMetricFamily(mfs, threadPoolMaxConnectionGauge);
            }
        }
        catch (Exception e) {
            log.error((Object)("Error retrieving metric:" + e.getMessage()));
        }
    }

    private void addVersionInfo(List<Collector.MetricFamilySamples> mfs) {
        GaugeMetricFamily tomcatInfo = new GaugeMetricFamily("tomcat_info", "tomcat version info", Arrays.asList("version", "build"));
        tomcatInfo.addMetric(Arrays.asList(ServerInfo.getServerNumber(), ServerInfo.getServerBuilt()), 1.0);
        mfs.add((Collector.MetricFamilySamples)tomcatInfo);
    }

    private void addNonEmptyMetricFamily(List<Collector.MetricFamilySamples> mfs, GaugeMetricFamily metricFamily) {
        if (metricFamily.samples.size() > 0) {
            mfs.add((Collector.MetricFamilySamples)metricFamily);
        }
    }

    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        this.addSessionMetrics(mfs);
        this.addThreadPoolMetrics(mfs);
        this.addRequestProcessorMetrics(mfs);
        this.addVersionInfo(mfs);
        return mfs;
    }
}

