/*
 * Decompiled with CFR 0.152.
 */
package nl.nlighten.prometheus.tomcat;

import io.prometheus.client.Gauge;
import io.prometheus.client.Histogram;
import java.util.Map;
import org.apache.tomcat.jdbc.pool.ConnectionPool;
import org.apache.tomcat.jdbc.pool.PoolProperties;
import org.apache.tomcat.jdbc.pool.PooledConnection;
import org.apache.tomcat.jdbc.pool.interceptor.AbstractQueryReport;

public class TomcatJdbcInterceptor
extends AbstractQueryReport {
    private static Histogram globalQueryStats;
    private static Histogram slowQueryStats;
    private static Gauge failedQueryStats;
    private boolean slowQueryStatsEnabled;
    private boolean failedQueryStatsEnabled;
    private long slowQueryThreshold = 1000L;
    public static final String SUCCESS_QUERY_STATUS = "success";
    public static final String FAILED_QUERY_STATUS = "error";

    public void setProperties(Map<String, PoolProperties.InterceptorProperty> properties) {
        PoolProperties.InterceptorProperty failedQueryStatsProperty;
        PoolProperties.InterceptorProperty slowQueryThresholdProperty;
        PoolProperties.InterceptorProperty slowQueryStatsProperty;
        double[] slowQueryBuckets;
        PoolProperties.InterceptorProperty slowQueryBucketsProperty;
        double[] buckets;
        PoolProperties.InterceptorProperty bucketsProperty = properties.get("buckets");
        if (bucketsProperty != null) {
            String[] bucketParams = bucketsProperty.getValue().split("\\|");
            buckets = new double[bucketParams.length];
            for (int i = 0; i < bucketParams.length; ++i) {
                buckets[i] = Double.parseDouble(bucketParams[i]);
            }
        } else {
            buckets = new double[]{0.01, 0.05, 0.1, 0.25, 0.5, 1.0, 2.5, 10.0};
        }
        if (globalQueryStats == null) {
            Histogram.Builder builder = (Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().help("JDBC query duration")).name("tomcat_jdbc_query_seconds")).buckets(buckets).labelNames(new String[]{"status"});
            globalQueryStats = (Histogram)builder.register();
        }
        if ((slowQueryBucketsProperty = properties.get("slowQueryBuckets")) != null) {
            String[] bucketParams = slowQueryBucketsProperty.getValue().split("\\|");
            slowQueryBuckets = new double[bucketParams.length];
            for (int i = 0; i < bucketParams.length; ++i) {
                slowQueryBuckets[i] = Double.parseDouble(bucketParams[i]);
            }
        } else {
            slowQueryBuckets = new double[]{1.0, 2.5, 10.0, 30.0};
        }
        if ((slowQueryStatsProperty = properties.get("logSlow")) != null && slowQueryStatsProperty.getValue().equals("true")) {
            this.slowQueryStatsEnabled = true;
            if (slowQueryStats == null) {
                Histogram.Builder builder = (Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().help("JDBC slow query duration in seconds")).name("tomcat_jdbc_slowquery_seconds")).buckets(slowQueryBuckets).labelNames(new String[]{"query"});
                slowQueryStats = (Histogram)builder.register();
            }
        }
        if ((slowQueryThresholdProperty = properties.get("threshold")) != null) {
            this.slowQueryThreshold = Long.parseLong(slowQueryThresholdProperty.getValue());
        }
        if ((failedQueryStatsProperty = properties.get("logFailed")) != null && failedQueryStatsProperty.getValue().equals("true")) {
            this.failedQueryStatsEnabled = true;
            if (failedQueryStats == null) {
                Gauge.Builder builder = (Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().help("Number of errors for give JDBC query")).name("tomcat_jdbc_failedquery_total")).labelNames(new String[]{"query"});
                failedQueryStats = (Gauge)builder.register();
            }
        }
    }

    protected String reportFailedQuery(String query, Object[] args, String name, long start, Throwable t) {
        String sql = super.reportFailedQuery(query, args, name, start, t);
        long now = System.currentTimeMillis();
        long delta = now - start;
        ((Histogram.Child)globalQueryStats.labels(new String[]{FAILED_QUERY_STATUS})).observe((double)(delta / 1000L));
        if (this.failedQueryStatsEnabled) {
            ((Gauge.Child)failedQueryStats.labels(new String[]{sql})).inc();
        }
        return sql;
    }

    protected String reportQuery(String query, Object[] args, String name, long start, long delta) {
        String sql = super.reportQuery(query, args, name, start, delta);
        ((Histogram.Child)globalQueryStats.labels(new String[]{SUCCESS_QUERY_STATUS})).observe((double)(delta / 1000L));
        if (this.slowQueryStatsEnabled && delta >= this.slowQueryThreshold) {
            ((Histogram.Child)slowQueryStats.labels(new String[]{sql})).observe((double)(delta / 1000L));
        }
        return sql;
    }

    protected String reportSlowQuery(String query, Object[] args, String name, long start, long delta) {
        String sql = super.reportSlowQuery(query, args, name, start, delta);
        ((Histogram.Child)globalQueryStats.labels(new String[]{SUCCESS_QUERY_STATUS})).observe((double)(delta / 1000L));
        if (this.slowQueryStatsEnabled && delta >= this.slowQueryThreshold) {
            ((Histogram.Child)slowQueryStats.labels(new String[]{sql})).observe((double)(delta / 1000L));
        }
        return sql;
    }

    public void closeInvoked() {
    }

    public void prepareStatement(String sql, long time) {
    }

    public void prepareCall(String sql, long time) {
    }

    public void poolStarted(ConnectionPool pool) {
        super.poolStarted(pool);
    }

    public void poolClosed(ConnectionPool pool) {
        super.poolClosed(pool);
    }

    public void reset(ConnectionPool parent, PooledConnection con) {
        super.reset(parent, con);
    }
}

