/*
 * Decompiled with CFR 0.152.
 */
package nl.nlighten.prometheus.wildfly;

import io.prometheus.client.Gauge;
import io.prometheus.client.Histogram;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletMetricsFilter
implements Filter {
    public static final String BUCKET_CONFIG_PARAM = "buckets";
    private static Histogram servletLatency;
    private static Gauge servletConcurrentRequest;
    private static Gauge servletStatusCodes;
    private static int UNDEFINED_HTTP_STATUS;

    public void init(FilterConfig filterConfig) throws ServletException {
        if (servletLatency == null) {
            Histogram.Builder servletLatencyBuilder = (Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().name("servlet_request_seconds")).help("The time taken fulfilling servlet requests")).labelNames(new String[]{"context", "method"});
            if (filterConfig.getInitParameter(BUCKET_CONFIG_PARAM) != null && !filterConfig.getInitParameter(BUCKET_CONFIG_PARAM).isEmpty()) {
                String[] bucketParams = filterConfig.getInitParameter(BUCKET_CONFIG_PARAM).split(",");
                double[] buckets = new double[bucketParams.length];
                for (int i = 0; i < bucketParams.length; ++i) {
                    buckets[i] = Double.parseDouble(bucketParams[i].trim());
                }
                servletLatencyBuilder.buckets(buckets);
            } else {
                servletLatencyBuilder.buckets(new double[]{0.01, 0.05, 0.1, 0.25, 0.5, 1.0, 2.5, 5.0, 10.0, 30.0});
            }
            servletLatency = (Histogram)servletLatencyBuilder.register();
            Gauge.Builder servletConcurrentRequestBuilder = (Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("servlet_request_concurrent_total")).help("Number of concurrent requests for given context.")).labelNames(new String[]{"context"});
            servletConcurrentRequest = (Gauge)servletConcurrentRequestBuilder.register();
            Gauge.Builder servletStatusCodesBuilder = (Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("servlet_response_status_total")).help("Number of requests for given context and status code.")).labelNames(new String[]{"context", "status"});
            servletStatusCodes = (Gauge)servletStatusCodesBuilder.register();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        block4: {
            block3: {
                if (!(servletRequest instanceof HttpServletRequest)) {
                    filterChain.doFilter(servletRequest, servletResponse);
                    return;
                }
                HttpServletRequest request = (HttpServletRequest)servletRequest;
                if (request.isAsyncStarted()) break block3;
                String context = this.getContext(request);
                ((Gauge.Child)servletConcurrentRequest.labels(new String[]{context})).inc();
                Histogram.Timer timer = ((Histogram.Child)servletLatency.labels(new String[]{context, request.getMethod()})).startTimer();
                try {
                    filterChain.doFilter(servletRequest, servletResponse);
                }
                catch (Throwable throwable) {
                    timer.observeDuration();
                    ((Gauge.Child)servletConcurrentRequest.labels(new String[]{context})).dec();
                    ((Gauge.Child)servletStatusCodes.labels(new String[]{context, Integer.toString(this.getStatus((HttpServletResponse)servletResponse))})).inc();
                    throw throwable;
                }
                timer.observeDuration();
                ((Gauge.Child)servletConcurrentRequest.labels(new String[]{context})).dec();
                ((Gauge.Child)servletStatusCodes.labels(new String[]{context, Integer.toString(this.getStatus((HttpServletResponse)servletResponse))})).inc();
                break block4;
            }
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    private int getStatus(HttpServletResponse response) {
        try {
            return response.getStatus();
        }
        catch (Exception ex) {
            return UNDEFINED_HTTP_STATUS;
        }
    }

    private String getContext(HttpServletRequest request) {
        if (request.getContextPath() != null && !request.getContextPath().isEmpty()) {
            return request.getContextPath();
        }
        return "/";
    }

    public void destroy() {
    }

    static {
        UNDEFINED_HTTP_STATUS = 999;
    }
}

