/*
 * Decompiled with CFR 0.152.
 */
package nl.nlighten.prometheus.wildfly;

import io.prometheus.client.Collector;
import io.prometheus.client.CounterMetricFamily;
import io.prometheus.client.GaugeMetricFamily;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import nl.nlighten.prometheus.wildfly.Util;

public class InfinispanExports
extends Collector {
    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            ObjectName filterName = new ObjectName("org.wildfly.clustering.infinispan:component=Statistics,name=*,manager=*,type=Cache");
            Set<ObjectInstance> mBeans = server.queryMBeans(filterName, null);
            if (mBeans.size() > 0) {
                GaugeMetricFamily hitRatioGauge = new GaugeMetricFamily("infinispan_hit_ratio", "Cache hit ratio", Arrays.asList("name", "manager"));
                CounterMetricFamily hitsCounter = new CounterMetricFamily("infinispan_hit_total", "Number of hits", Arrays.asList("name", "manager"));
                CounterMetricFamily missesCounter = new CounterMetricFamily("infinispan_miss_total", "Number of misses", Arrays.asList("name", "manager"));
                GaugeMetricFamily numberOfEntriesGauge = new GaugeMetricFamily("infinispan_entries_total", "Number of entries", Arrays.asList("name", "manager"));
                CounterMetricFamily evictionsCounter = new CounterMetricFamily("infinispan_evictions_total", "Number of evictions", Arrays.asList("name", "manager"));
                for (ObjectInstance mBean : mBeans) {
                    hitRatioGauge.addMetric(Arrays.asList(Util.sanitizeLabel(mBean.getObjectName().getKeyProperty("name")), Util.sanitizeLabel(mBean.getObjectName().getKeyProperty("manager"))), ((Double)server.getAttribute(mBean.getObjectName(), "hitRatio")).doubleValue());
                    hitsCounter.addMetric(Arrays.asList(Util.sanitizeLabel(mBean.getObjectName().getKeyProperty("name")), Util.sanitizeLabel(mBean.getObjectName().getKeyProperty("manager"))), ((Long)server.getAttribute(mBean.getObjectName(), "hits")).doubleValue());
                    missesCounter.addMetric(Arrays.asList(Util.sanitizeLabel(mBean.getObjectName().getKeyProperty("name")), Util.sanitizeLabel(mBean.getObjectName().getKeyProperty("manager"))), ((Long)server.getAttribute(mBean.getObjectName(), "misses")).doubleValue());
                    numberOfEntriesGauge.addMetric(Arrays.asList(Util.sanitizeLabel(mBean.getObjectName().getKeyProperty("name")), Util.sanitizeLabel(mBean.getObjectName().getKeyProperty("manager"))), ((Integer)server.getAttribute(mBean.getObjectName(), "numberOfEntries")).doubleValue());
                    evictionsCounter.addMetric(Arrays.asList(Util.sanitizeLabel(mBean.getObjectName().getKeyProperty("name")), Util.sanitizeLabel(mBean.getObjectName().getKeyProperty("manager"))), ((Long)server.getAttribute(mBean.getObjectName(), "evictions")).doubleValue());
                }
                mfs.add((Collector.MetricFamilySamples)hitRatioGauge);
                mfs.add((Collector.MetricFamilySamples)hitsCounter);
                mfs.add((Collector.MetricFamilySamples)missesCounter);
                mfs.add((Collector.MetricFamilySamples)numberOfEntriesGauge);
                mfs.add((Collector.MetricFamilySamples)evictionsCounter);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mfs;
    }
}

