/*
 * Decompiled with CFR 0.152.
 */
package nl.nlighten.prometheus.wildfly;

import io.prometheus.client.Collector;
import io.prometheus.client.CounterMetricFamily;
import io.prometheus.client.GaugeMetricFamily;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;

public class JbossJdbcPoolExports
extends Collector {
    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        try {
            List<String> labelList;
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            ObjectName filterName = new ObjectName("jboss.as:subsystem=datasources,data-source=*,statistics=pool");
            Set<ObjectInstance> mBeans = server.queryMBeans(filterName, null);
            if (mBeans.size() > 0) {
                labelList = Collections.singletonList("pool");
                GaugeMetricFamily activeCountGauge = new GaugeMetricFamily("jboss_jdbc_connections_total", "Total number of connections in this pool", labelList);
                GaugeMetricFamily waitCountGauge = new GaugeMetricFamily("jboss_jdbc_connections_threadswaiting_total", "Number of threads waiting for connections from this pool", labelList);
                GaugeMetricFamily idleCountGauge = new GaugeMetricFamily("jboss_jdbc_connections_idle_total", "Number of idle connections in this pool", labelList);
                GaugeMetricFamily inUseCountGauge = new GaugeMetricFamily("jboss_jdbc_connections_active_total", "Number of connections in use", labelList);
                CounterMetricFamily xaCommitCounter = new CounterMetricFamily("jboss_jdbc_xacommit_total", "Number of xa commits", labelList);
                CounterMetricFamily xaRollbackCounter = new CounterMetricFamily("jboss_jdbc_xarollback_total", "Number of xa recoveries", labelList);
                CounterMetricFamily xaRecoverCounter = new CounterMetricFamily("jboss_jdbc_xarecover_total", "Number of xa recoveries", labelList);
                for (ObjectInstance mBean : mBeans) {
                    activeCountGauge.addMetric(Collections.singletonList(mBean.getObjectName().getKeyProperty("data-source")), ((Integer)server.getAttribute(mBean.getObjectName(), "ActiveCount")).doubleValue());
                    waitCountGauge.addMetric(Collections.singletonList(mBean.getObjectName().getKeyProperty("data-source")), ((Integer)server.getAttribute(mBean.getObjectName(), "WaitCount")).doubleValue());
                    idleCountGauge.addMetric(Collections.singletonList(mBean.getObjectName().getKeyProperty("data-source")), ((Integer)server.getAttribute(mBean.getObjectName(), "IdleCount")).doubleValue());
                    inUseCountGauge.addMetric(Collections.singletonList(mBean.getObjectName().getKeyProperty("data-source")), ((Integer)server.getAttribute(mBean.getObjectName(), "InUseCount")).doubleValue());
                    xaCommitCounter.addMetric(Collections.singletonList(mBean.getObjectName().getKeyProperty("data-source")), ((Long)server.getAttribute(mBean.getObjectName(), "XACommitCount")).doubleValue());
                    xaRollbackCounter.addMetric(Collections.singletonList(mBean.getObjectName().getKeyProperty("data-source")), ((Long)server.getAttribute(mBean.getObjectName(), "XARollbackCount")).doubleValue());
                    xaRecoverCounter.addMetric(Collections.singletonList(mBean.getObjectName().getKeyProperty("data-source")), ((Long)server.getAttribute(mBean.getObjectName(), "XARecoverCount")).doubleValue());
                }
                mfs.add((Collector.MetricFamilySamples)activeCountGauge);
                mfs.add((Collector.MetricFamilySamples)waitCountGauge);
                mfs.add((Collector.MetricFamilySamples)inUseCountGauge);
                mfs.add((Collector.MetricFamilySamples)xaCommitCounter);
                mfs.add((Collector.MetricFamilySamples)xaRollbackCounter);
                mfs.add((Collector.MetricFamilySamples)xaRecoverCounter);
            }
            if ((mBeans = server.queryMBeans(filterName = new ObjectName("jboss.as:subsystem=datasources,data-source=*,statistics=jdbc"), null)).size() > 0) {
                labelList = Collections.singletonList("pool");
                GaugeMetricFamily preparedStatementCacheCurrentSizeGauge = new GaugeMetricFamily("jboss_jdbc_preparedstatementcache_size_total", "Prepared statement cache size", labelList);
                CounterMetricFamily preparedStatementCacheMissCounter = new CounterMetricFamily("jboss_jdbc_preparedstatementcache_miss_total", "Prepared statement cache miss count", labelList);
                CounterMetricFamily preparedStatementCacheHitCounter = new CounterMetricFamily("jboss_jdbc_preparedstatementcache_hit_total", "Prepared statement cache hit count", labelList);
                for (ObjectInstance mBean : mBeans) {
                    preparedStatementCacheCurrentSizeGauge.addMetric(Collections.singletonList(mBean.getObjectName().getKeyProperty("data-source")), ((Integer)server.getAttribute(mBean.getObjectName(), "PreparedStatementCacheCurrentSize")).doubleValue());
                    preparedStatementCacheMissCounter.addMetric(Collections.singletonList(mBean.getObjectName().getKeyProperty("data-source")), ((Long)server.getAttribute(mBean.getObjectName(), "PreparedStatementCacheMissCount")).doubleValue());
                    preparedStatementCacheHitCounter.addMetric(Collections.singletonList(mBean.getObjectName().getKeyProperty("data-source")), ((Long)server.getAttribute(mBean.getObjectName(), "PreparedStatementCacheHitCount")).doubleValue());
                }
                mfs.add((Collector.MetricFamilySamples)preparedStatementCacheCurrentSizeGauge);
                mfs.add((Collector.MetricFamilySamples)preparedStatementCacheMissCounter);
                mfs.add((Collector.MetricFamilySamples)preparedStatementCacheHitCounter);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mfs;
    }
}

