/*
 * Decompiled with CFR 0.152.
 */
package nl.nlighten.prometheus.wildfly;

import io.prometheus.client.Collector;
import io.prometheus.client.GaugeMetricFamily;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;

public class WildflyVersionExports
extends Collector {
    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            ObjectName filterName = new ObjectName("jboss.as:management-root=server");
            Set<ObjectInstance> mBeans = server.queryMBeans(filterName, null);
            if (mBeans.size() > 0) {
                GaugeMetricFamily wildflyInfo = new GaugeMetricFamily("wildfly_info", "Wildfly version info", Arrays.asList("name", "version"));
                for (ObjectInstance mBean : mBeans) {
                    wildflyInfo.addMetric(Arrays.asList((String)server.getAttribute(mBean.getObjectName(), "productName"), (String)server.getAttribute(mBean.getObjectName(), "productVersion")), 1.0);
                }
                mfs.add((Collector.MetricFamilySamples)wildflyInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mfs;
    }
}

