/*
 * Decompiled with CFR 0.152.
 */
package nl.pragmasoft.pekko.persistence.inmemory.util;

import java.util.Calendar;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicLong;

public class UUIDUtil {
    public static final long START_EPOCH = UUIDUtil.makeEpoch();
    public static final AtomicLong lastTimestamp = new AtomicLong(0L);

    public static long getCurrentTimestamp() {
        long l;
        while (true) {
            long l2;
            long l3;
            if ((l3 = UUIDUtil.fromUnixTimestamp(System.currentTimeMillis())) > (l2 = lastTimestamp.get())) {
                if (!lastTimestamp.compareAndSet(l2, l3)) continue;
                return l3;
            }
            long l4 = UUIDUtil.millisOf(l2);
            if (UUIDUtil.millisOf(l3) < UUIDUtil.millisOf(l2)) {
                return lastTimestamp.incrementAndGet();
            }
            l = l2 + 1L;
            if (UUIDUtil.millisOf(l) == l4 && lastTimestamp.compareAndSet(l2, l)) break;
        }
        return l;
    }

    public static long makeEpoch() {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT-0"));
        calendar.set(1, 1582);
        calendar.set(2, 9);
        calendar.set(5, 15);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    public static long fromUnixTimestamp(long l) {
        return (l - START_EPOCH) * 10000L;
    }

    public static long millisOf(long l) {
        return l / 10000L;
    }
}

