/*
 * Decompiled with CFR 0.152.
 */
package nl.pragmasoft.pekko.persistence.inmemory.util;

import java.io.Serializable;
import java.util.UUID;
import nl.pragmasoft.pekko.persistence.inmemory.util.UUIDUtil;
import org.apache.pekko.persistence.query.TimeBasedUUID;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Some;
import scala.math.Ordering;
import scala.math.PartialOrdering;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt;
import scala.runtime.RichLong;
import scala.util.Random;

public final class UUIDs$ {
    public static final UUIDs$ MODULE$ = new UUIDs$();
    private static final Ordering<TimeBasedUUID> TimeBasedUUIDOrdering = new Ordering<TimeBasedUUID>(){

        public Some tryCompare(Object x, Object y) {
            return Ordering.tryCompare$((Ordering)this, (Object)x, (Object)y);
        }

        public boolean lteq(Object x, Object y) {
            return Ordering.lteq$((Ordering)this, (Object)x, (Object)y);
        }

        public boolean gteq(Object x, Object y) {
            return Ordering.gteq$((Ordering)this, (Object)x, (Object)y);
        }

        public boolean lt(Object x, Object y) {
            return Ordering.lt$((Ordering)this, (Object)x, (Object)y);
        }

        public boolean gt(Object x, Object y) {
            return Ordering.gt$((Ordering)this, (Object)x, (Object)y);
        }

        public boolean equiv(Object x, Object y) {
            return Ordering.equiv$((Ordering)this, (Object)x, (Object)y);
        }

        public Object max(Object x, Object y) {
            return Ordering.max$((Ordering)this, (Object)x, (Object)y);
        }

        public Object min(Object x, Object y) {
            return Ordering.min$((Ordering)this, (Object)x, (Object)y);
        }

        public Ordering<TimeBasedUUID> reverse() {
            return Ordering.reverse$((Ordering)this);
        }

        public boolean isReverseOf(Ordering<?> other) {
            return Ordering.isReverseOf$((Ordering)this, other);
        }

        public <U> Ordering<U> on(Function1<U, TimeBasedUUID> f) {
            return Ordering.on$((Ordering)this, f);
        }

        public Ordering<TimeBasedUUID> orElse(Ordering<TimeBasedUUID> other) {
            return Ordering.orElse$((Ordering)this, other);
        }

        public <S> Ordering<TimeBasedUUID> orElseBy(Function1<TimeBasedUUID, S> f, Ordering<S> ord) {
            return Ordering.orElseBy$((Ordering)this, f, ord);
        }

        public Ordering.OrderingOps mkOrderingOps(Object lhs) {
            return Ordering.mkOrderingOps$((Ordering)this, (Object)lhs);
        }

        public int compare(TimeBasedUUID x, TimeBasedUUID y) {
            UUID xuuid = x.value();
            UUID yuuid = y.value();
            int comparedByTimestamp = new RichLong(Predef$.MODULE$.longWrapper(xuuid.timestamp())).compare((Object)BoxesRunTime.boxToLong((long)yuuid.timestamp()));
            if (comparedByTimestamp == 0) {
                int comparedByClock = new RichInt(Predef$.MODULE$.intWrapper(xuuid.clockSequence())).compare((Object)BoxesRunTime.boxToInteger((int)yuuid.clockSequence()));
                if (comparedByClock == 0) {
                    return new RichLong(Predef$.MODULE$.longWrapper(xuuid.node())).compare((Object)BoxesRunTime.boxToLong((long)yuuid.node()));
                }
                return comparedByClock;
            }
            return comparedByTimestamp;
        }
        {
            PartialOrdering.$init$((PartialOrdering)this);
            Ordering.$init$((Ordering)this);
        }
    };
    private static final long MIN_CLOCK_SEQ_AND_NODE = -9187201950435737472L;
    private static final long NODE = 256475483242313L;
    private static final long ClockSeqAndNode;

    static {
        long clock = new Random(System.currentTimeMillis()).nextLong();
        ClockSeqAndNode = 0L | (clock & 0x3FFFL) << 48 | Long.MIN_VALUE | MODULE$.NODE();
    }

    public Ordering<TimeBasedUUID> TimeBasedUUIDOrdering() {
        return TimeBasedUUIDOrdering;
    }

    public final long MIN_CLOCK_SEQ_AND_NODE() {
        return MIN_CLOCK_SEQ_AND_NODE;
    }

    public final long NODE() {
        return NODE;
    }

    public UUID startOf(long timestamp) {
        return new UUID(this.makeMSB(UUIDUtil.fromUnixTimestamp(timestamp)), this.MIN_CLOCK_SEQ_AND_NODE());
    }

    public UUID timeBased() {
        return new UUID(this.makeMSB(UUIDUtil.getCurrentTimestamp()), this.ClockSeqAndNode());
    }

    public final long ClockSeqAndNode() {
        return ClockSeqAndNode;
    }

    public long makeMSB(long timestamp) {
        return 0L | (0xFFFFFFFFL & timestamp) << 32 | (0xFFFF00000000L & timestamp) >>> 16 | (0xFFF000000000000L & timestamp) >>> 48 | 0x1000L;
    }

    public long unixTimestamp(UUID uuid) {
        Predef$.MODULE$.require(uuid.version() == 1, (Function0 & Serializable)() -> new StringBuilder(75).append("Can only retrieve the unix timestamp for version 1 uuid (provided version ").append(uuid.version()).append(")").toString());
        long timestamp = uuid.timestamp();
        return timestamp / 10000L + UUIDUtil.START_EPOCH;
    }

    private UUIDs$() {
    }
}

