/*
 * Decompiled with CFR 0.152.
 */
package nl.pragmasoft.pekko.sensors;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import nl.pragmasoft.pekko.sensors.PekkoSensors$;
import nl.pragmasoft.pekko.sensors.RunnableWatcher;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.MapFactoryDefaults;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

public final class RunnableWatcher$
implements LazyLogging {
    public static final RunnableWatcher$ MODULE$ = new RunnableWatcher$();
    private static ThreadMXBean threads;
    private static transient Logger logger;
    private static volatile boolean bitmap$0;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
    }

    private Logger logger$lzycompute() {
        RunnableWatcher$ runnableWatcher$ = this;
        synchronized (runnableWatcher$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    private ThreadMXBean threads$lzycompute() {
        RunnableWatcher$ runnableWatcher$ = this;
        synchronized (runnableWatcher$) {
            if (!bitmap$0) {
                threads = ManagementFactory.getThreadMXBean();
                bitmap$0 = true;
            }
        }
        return threads;
    }

    private ThreadMXBean threads() {
        if (!bitmap$0) {
            return this.threads$lzycompute();
        }
        return threads;
    }

    public RunnableWatcher apply(Duration tooLongRunThreshold, Duration checkInterval, int maxDepth, ThreadMXBean threads) {
        TrieMap cache = TrieMap$.MODULE$.empty();
        PekkoSensors$.MODULE$.schedule("RunnableWatcher", () -> {
            try {
                long currentTime = System.nanoTime();
                ((MapFactoryDefaults)cache.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)RunnableWatcher$.$anonfun$apply$2(check$ifrefutable$1))).map((Function1 & Serializable)x$2 -> {
                    Tuple2 tuple2 = x$2;
                    if (tuple2 != null) {
                        Long startTime = (Long)tuple2._2();
                        FiniteDuration duration = new package.DurationLong(package$.MODULE$.DurationLong(currentTime - Predef$.MODULE$.Long2long(startTime))).nanos();
                        return new Tuple2((Object)tuple2, (Object)duration);
                    }
                    throw new MatchError((Object)tuple2);
                })).withFilter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)RunnableWatcher$.$anonfun$apply$4(tooLongRunThreshold, x$3))).foreach((Function1 & Serializable)x$5 -> {
                    RunnableWatcher$.$anonfun$apply$5(cache, threads, maxDepth, x$5);
                    return BoxedUnit.UNIT;
                });
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (NonFatal$.MODULE$.apply(throwable2)) {
                    if (MODULE$.logger().underlying().isErrorEnabled()) {
                        MODULE$.logger().underlying().error(new StringBuilder(33).append("failed to check hanging threads: ").append(throwable2).toString(), throwable2);
                    }
                }
                throw throwable;
            }
        }, checkInterval);
        Function1 & Serializable startWatching = (Function1 & Serializable)threadId -> {
            RunnableWatcher$.$anonfun$apply$8(cache, threadId);
            return BoxedUnit.UNIT;
        };
        Function1 & Serializable stopWatching = (Function1 & Serializable)threadId -> {
            cache.remove((Object)threadId);
            return BoxedUnit.UNIT;
        };
        return this.apply((Function1<Long, BoxedUnit>)startWatching, (Function1<Long, BoxedUnit>)stopWatching);
    }

    public RunnableWatcher apply(Function1<Long, BoxedUnit> startWatching, Function1<Long, BoxedUnit> stopWatching) {
        return new RunnableWatcher(startWatching, stopWatching){
            private final Function1 startWatching$1;
            private final Function1 stopWatching$1;

            public <T> T apply(Function0<T> f) {
                Object object;
                Function0<BoxedUnit> stop = this.start();
                try {
                    object = f.apply();
                }
                finally {
                    stop.apply$mcV$sp();
                }
                return (T)object;
            }

            public Function0<BoxedUnit> start() {
                long threadId = Thread.currentThread().getId();
                this.startWatching$1.apply((Object)Predef$.MODULE$.long2Long(threadId));
                return (JFunction0.mcV.sp & Serializable)() -> $this.stopWatching$1.apply((Object)Predef$.MODULE$.long2Long(threadId));
            }
            {
                this.startWatching$1 = startWatching$1;
                this.stopWatching$1 = stopWatching$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$start$1(nl.pragmasoft.pekko.sensors.RunnableWatcher$$anon$1 long )}, serializedLambda);
            }
        };
    }

    public Duration apply$default$2() {
        return new package.DurationInt(package$.MODULE$.DurationInt(1)).second();
    }

    public int apply$default$3() {
        return 300;
    }

    public ThreadMXBean apply$default$4() {
        return this.threads();
    }

    public String stackTraceToString(StackTraceElement[] xs) {
        return Predef$.MODULE$.wrapRefArray((Object[])xs).mkString("\tat ", "\n\tat ", "");
    }

    public static final /* synthetic */ boolean $anonfun$apply$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$apply$4(Duration tooLongRunThreshold$1, Tuple2 x$3) {
        Tuple2 tuple2 = x$3;
        if (tuple2 != null) {
            Tuple2 tuple22 = (Tuple2)tuple2._1();
            FiniteDuration duration = (FiniteDuration)tuple2._2();
            if (tuple22 != null) {
                return duration.$greater$eq((Object)tooLongRunThreshold$1);
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$apply$7(FiniteDuration duration$1, ThreadInfo threadInfo) {
        BoxedUnit boxedUnit;
        String threadName = threadInfo.getThreadName();
        StackTraceElement[] stackTrace = threadInfo.getStackTrace();
        String formattedStackTrace = MODULE$.stackTraceToString(stackTrace);
        if (MODULE$.logger().underlying().isErrorEnabled()) {
            MODULE$.logger().underlying().error("Detected a thread that is locked for {} ms: {}, current state:\t{}", new Object[]{BoxesRunTime.boxToLong((long)duration$1.toMillis()), threadName, formattedStackTrace});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$apply$6(ThreadMXBean threads$1, Long threadId$1, int maxDepth$1, FiniteDuration duration$1, Long x$4) {
        Long l = x$4;
        Option$.MODULE$.apply((Object)threads$1.getThreadInfo(Predef$.MODULE$.Long2long(threadId$1), maxDepth$1)).foreach((Function1 & Serializable)threadInfo -> {
            RunnableWatcher$.$anonfun$apply$7(duration$1, threadInfo);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$apply$5(TrieMap cache$1, ThreadMXBean threads$1, int maxDepth$1, Tuple2 x$5) {
        Tuple2 tuple2 = x$5;
        if (tuple2 != null) {
            Tuple2 tuple22 = (Tuple2)tuple2._1();
            FiniteDuration duration = (FiniteDuration)tuple2._2();
            if (tuple22 != null) {
                Long threadId = (Long)tuple22._1();
                cache$1.remove((Object)threadId).foreach((Function1 & Serializable)x$4 -> {
                    RunnableWatcher$.$anonfun$apply$6(threads$1, threadId, maxDepth$1, duration, x$4);
                    return BoxedUnit.UNIT;
                });
                return;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$apply$8(TrieMap cache$1, Long threadId) {
        long startTime = System.nanoTime();
        cache$1.put((Object)threadId, (Object)Predef$.MODULE$.long2Long(startTime));
    }

    private RunnableWatcher$() {
    }
}

