/*
 * Decompiled with CFR 0.152.
 */
package nl.pragmasoft.pekko.sensors;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.prometheus.client.CollectorRegistry;
import java.io.Serializable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.concurrent.TrieMap;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

public final class PekkoSensors$
implements LazyLogging {
    public static final PekkoSensors$ MODULE$ = new PekkoSensors$();
    private static final Config config;
    private static final long defaultPollInterval;
    private static final boolean ClusterWatchEnabled;
    private static final ScheduledExecutorService executor;
    private static final TrieMap<String, Runnable> periodicPolls;
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
        config = ConfigFactory.load().getConfig("pekko.sensors");
        defaultPollInterval = BoxesRunTime.unboxToLong((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable)() -> MODULE$.config().getDuration("thread-state-snapshot-period", TimeUnit.SECONDS)).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 1L));
        ClusterWatchEnabled = BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> MODULE$.config().getBoolean("cluster-watch-enabled")).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
        executor = Executors.newScheduledThreadPool(1);
        periodicPolls = new TrieMap();
    }

    private Logger logger$lzycompute() {
        PekkoSensors$ pekkoSensors$ = this;
        synchronized (pekkoSensors$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    private Config config() {
        return config;
    }

    private long defaultPollInterval() {
        return defaultPollInterval;
    }

    public boolean ClusterWatchEnabled() {
        return ClusterWatchEnabled;
    }

    private ScheduledExecutorService executor() {
        return executor;
    }

    private TrieMap<String, Runnable> periodicPolls() {
        return periodicPolls;
    }

    public void schedule(String id, Runnable poll, Duration interval) {
        this.periodicPolls().getOrElseUpdate((Object)id, (Function0 & Serializable)() -> {
            BoxedUnit boxedUnit;
            MODULE$.executor().scheduleWithFixedDelay(poll, interval.length(), interval.length(), interval.unit());
            if (MODULE$.logger().underlying().isInfoEnabled()) {
                MODULE$.logger().underlying().info("Scheduled activity: {}", (Object)id);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return poll;
        });
    }

    public Duration schedule$default$3() {
        return Duration$.MODULE$.apply(this.defaultPollInterval(), TimeUnit.SECONDS);
    }

    public CollectorRegistry prometheusRegistry() {
        return CollectorRegistry.defaultRegistry;
    }

    public String getSimpleName(Class<?> cls) {
        String string;
        try {
            string = cls.getSimpleName();
        }
        catch (InternalError internalError) {
            string = this.stripDollars(this.stripPackages(cls.getName()));
        }
        return string;
    }

    private String stripPackages(String fullyQualifiedName) {
        return ((String[])ArrayOps$.MODULE$.takeRight$extension(Predef$.MODULE$.refArrayOps((Object[])fullyQualifiedName.split("\\.")), 1))[0];
    }

    private String stripDollars(String s) {
        Option option;
        while (true) {
            int lastDollarIndex;
            if ((lastDollarIndex = s.lastIndexOf(36)) < s.length() - 1) {
                if (lastDollarIndex == -1 || !s.contains("$iw")) {
                    return s;
                }
                return s.substring(lastDollarIndex + 1);
            }
            Option lastNonDollarChar = StringOps$.MODULE$.find$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(s))), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)PekkoSensors$.$anonfun$stripDollars$1(BoxesRunTime.unboxToChar((Object)x$1))));
            option = lastNonDollarChar;
            if (None$.MODULE$.equals(option)) {
                return s;
            }
            if (!(option instanceof Some)) break;
            Some some = (Some)option;
            char c = BoxesRunTime.unboxToChar((Object)some.value());
            int lastNonDollarIndex = s.lastIndexOf(c);
            if (lastNonDollarIndex == -1) {
                return s;
            }
            s = s.substring(0, lastNonDollarIndex + 1);
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ boolean $anonfun$stripDollars$1(char x$1) {
        return x$1 != '$';
    }

    private PekkoSensors$() {
    }
}

