/*
 * Decompiled with CFR 0.152.
 */
package nl.pragmasoft.pekko.sensors.actor;

import io.prometheus.client.Counter;
import java.io.Serializable;
import org.apache.pekko.actor.typed.ActorRef;
import org.apache.pekko.actor.typed.ActorRef$;
import org.apache.pekko.actor.typed.Behavior;
import org.apache.pekko.actor.typed.PostStop$;
import org.apache.pekko.actor.typed.Signal;
import org.apache.pekko.actor.typed.scaladsl.ActorContext;
import org.apache.pekko.actor.typed.scaladsl.Behaviors$;
import org.apache.pekko.cluster.ClusterEvent;
import org.apache.pekko.cluster.Member;
import org.apache.pekko.cluster.MemberStatus;
import org.apache.pekko.cluster.typed.Cluster;
import org.apache.pekko.cluster.typed.Cluster$;
import org.apache.pekko.cluster.typed.Subscribe;
import org.apache.pekko.cluster.typed.Unsubscribe;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.runtime.BoxedUnit;

public final class ClusterEventWatchTypedActor$ {
    public static final ClusterEventWatchTypedActor$ MODULE$ = new ClusterEventWatchTypedActor$();

    public Behavior<ClusterEvent.ClusterDomainEvent> apply(Counter clusterEvents) {
        return Behaviors$.MODULE$.setup((Function1 & Serializable)context -> {
            Cluster cluster = (Cluster)Cluster$.MODULE$.apply(context.system());
            Logger log = context.log();
            Function2 & Serializable meterEvent = (Function2 & Serializable)(e, member) -> {
                ClusterEventWatchTypedActor$.MODULE$.registerEvent(clusterEvents, e, (Option<Member>)member);
                return BoxedUnit.UNIT;
            };
            ActorRef.ActorRefOps$.MODULE$.$bang$extension(ActorRef$.MODULE$.ActorRefOps(cluster.subscriptions()), (Object)new Subscribe(context.self(), ClusterEvent.MemberEvent.class));
            return Behaviors$.MODULE$.receiveMessage((Function1 & Serializable)event -> {
                ClusterEvent.ClusterDomainEvent clusterDomainEvent = event;
                if (clusterDomainEvent instanceof ClusterEvent.MemberUp) {
                    ClusterEvent.MemberUp memberUp = (ClusterEvent.MemberUp)clusterDomainEvent;
                    Member member = memberUp.member();
                    meterEvent.apply((Object)memberUp, (Object)new Some((Object)member));
                    log.info("Member is Up: {}", (Object)member.address());
                } else if (clusterDomainEvent instanceof ClusterEvent.UnreachableMember) {
                    ClusterEvent.UnreachableMember unreachableMember = (ClusterEvent.UnreachableMember)clusterDomainEvent;
                    Member member = unreachableMember.member();
                    meterEvent.apply((Object)unreachableMember, (Object)new Some((Object)member));
                    log.info("Member detected as unreachable: {}", (Object)member);
                } else if (clusterDomainEvent instanceof ClusterEvent.MemberRemoved) {
                    ClusterEvent.MemberRemoved memberRemoved = (ClusterEvent.MemberRemoved)clusterDomainEvent;
                    Member member = memberRemoved.member();
                    MemberStatus previousStatus = memberRemoved.previousStatus();
                    meterEvent.apply((Object)memberRemoved, (Object)new Some((Object)member));
                    log.info("Member is Removed: {} after {}", (Object)member.address(), (Object)previousStatus);
                } else if (clusterDomainEvent instanceof ClusterEvent.MemberDowned) {
                    ClusterEvent.MemberDowned memberDowned = (ClusterEvent.MemberDowned)clusterDomainEvent;
                    Member member = memberDowned.member();
                    meterEvent.apply((Object)memberDowned, (Object)new Some((Object)member));
                    log.info("Member is Down: {}", (Object)member.address());
                } else {
                    meterEvent.apply((Object)clusterDomainEvent, (Object)None$.MODULE$);
                    log.info(new StringBuilder(22).append("Cluster domain event: ").append(clusterDomainEvent).toString());
                }
                return Behaviors$.MODULE$.same();
            }).receiveSignal((PartialFunction)new Serializable(cluster, (ActorContext)context){
                private static final long serialVersionUID = 0L;
                private final Cluster cluster$1;
                private final ActorContext context$1;

                public final <A1 extends Tuple2<ActorContext<ClusterEvent.ClusterDomainEvent>, Signal>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Signal signal;
                    A1 A1 = x1;
                    if (A1 != null && PostStop$.MODULE$.equals(signal = (Signal)A1._2())) {
                        ActorRef.ActorRefOps$.MODULE$.$bang$extension(ActorRef$.MODULE$.ActorRefOps(this.cluster$1.subscriptions()), (Object)new Unsubscribe(this.context$1.self()));
                        return (B1)Behaviors$.MODULE$.same();
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Tuple2<ActorContext<ClusterEvent.ClusterDomainEvent>, Signal> x1) {
                    Signal signal;
                    Tuple2<ActorContext<ClusterEvent.ClusterDomainEvent>, Signal> tuple2 = x1;
                    return tuple2 != null && PostStop$.MODULE$.equals(signal = (Signal)tuple2._2());
                }
                {
                    this.cluster$1 = cluster$1;
                    this.context$1 = context$1;
                }
            });
        });
    }

    private void registerEvent(Counter clusterEvents, ClusterEvent.ClusterDomainEvent e, Option<Member> member) {
        ((Counter.Child)clusterEvents.labels(new String[]{e.getClass().getSimpleName(), (String)member.map((Function1 & Serializable)x$1 -> x$1.address().toString()).getOrElse((Function0 & Serializable)() -> "")})).inc();
    }

    private ClusterEventWatchTypedActor$() {
    }
}

