/*
 * Decompiled with CFR 0.152.
 */
package nl.pvanassen.geckoboard.api;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import nl.pvanassen.geckoboard.api.Push;
import nl.pvanassen.geckoboard.api.WidgetWrapper;
import nl.pvanassen.geckoboard.api.gson.GsonFactory;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Geckoboard {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final int RECOMMENDED_TIME_OUT = 70000;
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String CONTENT_TYPE_VALUE = "application/json";
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private String baseUrl = "https://push.geckoboard.com/v1/send/";
    private final String apiKey;

    private static void bestEffortToReleaseHttpWithoutExceptions(OutputStream httpOutputStream, InputStream httpInputStream, HttpURLConnection connection) {
        IOUtils.closeQuietly((OutputStream)httpOutputStream);
        IOUtils.closeQuietly((InputStream)httpInputStream);
        if (connection != null) {
            connection.disconnect();
        }
    }

    public Geckoboard(String apiKey) {
        if (apiKey == null || apiKey.trim().isEmpty()) {
            throw new IllegalArgumentException("Api key cannot be null or empty");
        }
        this.apiKey = apiKey;
    }

    private HttpURLConnection createAndOpenConnection(String widgetKey) throws IOException {
        URL url = new URL(this.baseUrl.concat(widgetKey));
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.addRequestProperty(CONTENT_TYPE, CONTENT_TYPE_VALUE);
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setConnectTimeout(70000);
        connection.setReadTimeout(70000);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(Push push) throws IOException {
        InputStream httpInputStream;
        OutputStream httpOutputStream;
        HttpURLConnection connection;
        block4: {
            if (push == null) {
                throw new IllegalArgumentException("Push cannot be empty");
            }
            WidgetWrapper wrapper = new WidgetWrapper(push, this.apiKey);
            Gson gson = GsonFactory.getGson();
            String json = gson.toJson((Object)wrapper);
            connection = null;
            httpOutputStream = null;
            httpInputStream = null;
            try {
                connection = this.createAndOpenConnection(push.getWidgetKey());
                httpOutputStream = connection.getOutputStream();
                this.logger.info("Sending: " + json);
                IOUtils.write((byte[])json.getBytes(DEFAULT_CHARSET), (OutputStream)httpOutputStream);
                if (connection.getResponseCode() < 400) break block4;
                this.logger.error("Error sending json, error: " + new String(IOUtils.toByteArray((InputStream)connection.getErrorStream()), DEFAULT_CHARSET) + ", json send: " + json);
            }
            catch (Throwable throwable) {
                Geckoboard.bestEffortToReleaseHttpWithoutExceptions(httpOutputStream, httpInputStream, connection);
                throw throwable;
            }
            Geckoboard.bestEffortToReleaseHttpWithoutExceptions(httpOutputStream, httpInputStream, connection);
            return;
        }
        httpInputStream = connection.getInputStream();
        byte[] responseXml = IOUtils.toByteArray((InputStream)httpInputStream);
        this.logger.info(new String(responseXml, DEFAULT_CHARSET));
        Geckoboard.bestEffortToReleaseHttpWithoutExceptions(httpOutputStream, httpInputStream, connection);
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }
}

