/*
 * Decompiled with CFR 0.152.
 */
package nl.pvanassen.geckoboard.api.gson;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.awt.Color;
import nl.pvanassen.geckoboard.api.gson.AwtColorTypeAdapter;
import nl.pvanassen.highchart.api.base.Style;
import nl.pvanassen.highchart.api.format.DateTimeLabelFormats;
import nl.pvanassen.highchart.api.serializer.DateTimeLabelFormatsSerializer;
import nl.pvanassen.highchart.api.serializer.StyleSerializer;

public final class GsonFactory {
    private final GsonBuilder gsonBuilder = new GsonBuilder();
    private static final String yyyy_MM_dd = "yyyyMMdd";
    private static final String USER_OBJECT = "userObject";
    private static final String WIDGET_KEY = "widgetKey";
    private static final GsonFactory INSTANCE = new GsonFactory();

    public static Gson getGson() {
        return GsonFactory.INSTANCE.gsonBuilder.create();
    }

    private GsonFactory() {
        this.gsonBuilder.registerTypeAdapter(Color.class, (Object)new AwtColorTypeAdapter());
        this.gsonBuilder.registerTypeAdapter(DateTimeLabelFormats.class, (Object)new DateTimeLabelFormatsSerializer());
        this.gsonBuilder.registerTypeAdapter(Style.class, (Object)new StyleSerializer());
        this.gsonBuilder.setDateFormat(yyyy_MM_dd);
        this.gsonBuilder.setExclusionStrategies(new ExclusionStrategy[]{new ExclusionStrategy(){

            public boolean shouldSkipClass(Class<?> arg0) {
                return false;
            }

            public boolean shouldSkipField(FieldAttributes attributes) {
                String name = attributes.getName();
                return name.equals(GsonFactory.USER_OBJECT) || name.equals(GsonFactory.WIDGET_KEY);
            }
        }});
    }
}

