/*
 * Decompiled with CFR 0.152.
 */
package nl.pvanassen.geckoboard.api.json.bulletgraph;

import com.google.gson.annotations.SerializedName;
import java.util.LinkedList;
import java.util.List;
import nl.pvanassen.geckoboard.api.error.ValidationException;
import nl.pvanassen.geckoboard.api.json.bulletgraph.Axis;
import nl.pvanassen.geckoboard.api.json.bulletgraph.Measure;
import nl.pvanassen.geckoboard.api.json.bulletgraph.Point;
import nl.pvanassen.geckoboard.api.json.bulletgraph.Position;
import nl.pvanassen.geckoboard.api.json.bulletgraph.Range;

public class BulletGraphItem {
    private String label;
    @SerializedName(value="sublabel")
    private String subLabel;
    private final Axis axis = new Axis();
    @SerializedName(value="range")
    private final List<Range> ranges = new LinkedList<Range>();
    private final Measure measure = new Measure();
    private Point comparative;

    public void setLabel(String label) {
        this.label = label;
    }

    public void setSubLabel(String subLabel) {
        this.subLabel = subLabel;
    }

    public List<String> getAxisPoints() {
        return this.axis.getPoints();
    }

    public List<Range> getRanges() {
        return this.ranges;
    }

    public void setCurrent(Position current) {
        this.measure.setCurrent(current);
    }

    public void setProjected(Position projected) {
        this.measure.setProjected(projected);
    }

    public void setComparative(String comparative) {
        this.comparative = new Point(comparative);
    }

    public void validate() throws ValidationException {
        if (this.label == null) {
            throw new ValidationException("item.label", "Label cannot be empty");
        }
        if (this.axis.getPoints().size() == 0) {
            throw new ValidationException("item.point", "Points must be set");
        }
        if (this.ranges.size() == 0) {
            throw new ValidationException("item.ranges", "Ranges must be set");
        }
        if (this.comparative == null) {
            throw new ValidationException("item.comparative", "Comparative must be set");
        }
        this.measure.validate();
        this.comparative.validate();
    }
}

