/*
 * Decompiled with CFR 0.152.
 */
package nl.pvanassen.geckoboard.api.widget;

import java.util.List;
import nl.pvanassen.geckoboard.api.Push;
import nl.pvanassen.geckoboard.api.error.ValidationException;
import nl.pvanassen.geckoboard.api.json.bulletgraph.BulletGraphItem;
import nl.pvanassen.geckoboard.api.json.bulletgraph.Position;
import nl.pvanassen.geckoboard.api.json.bulletgraph.RAGColor;
import nl.pvanassen.geckoboard.api.json.bulletgraph.Range;

public class BulletGraph
extends Push {
    private final String orientation;
    private final BulletGraphItem item = new BulletGraphItem();

    public BulletGraph(String widgetKey, boolean vertical) {
        super(widgetKey);
        this.orientation = vertical ? "vertical" : "horizontal";
    }

    public void addRange(int start, int end, RAGColor color) {
        this.item.getRanges().add(new Range(start, end, color));
    }

    public void setAxisPoints(List<String> points) {
        this.item.getAxisPoints().addAll(points);
    }

    public void setComparative(String position) {
        this.item.setComparative(position);
    }

    public void setCurrent(int start, int end) {
        this.item.setCurrent(new Position(start, end));
    }

    public void setLabel(String label) {
        this.item.setLabel(label);
    }

    public void setProjected(int start, int end) {
        this.item.setProjected(new Position(start, end));
    }

    public void setSubLabel(String subLabel) {
        this.item.setSubLabel(subLabel);
    }

    @Override
    protected void validate() throws ValidationException {
        this.item.validate();
    }
}

