/*
 * Decompiled with CFR 0.152.
 */
package nl.pvanassen.geckoboard.api.widget;

import com.google.gson.annotations.SerializedName;
import java.util.LinkedList;
import java.util.List;
import nl.pvanassen.geckoboard.api.Push;
import nl.pvanassen.geckoboard.api.error.ValidationException;
import nl.pvanassen.geckoboard.api.json.common.GraphType;
import nl.pvanassen.geckoboard.api.json.common.LabelValueItem;

public class FunnelGraph
extends Push {
    @SerializedName(value="item")
    private final List<LabelValueItem> items = new LinkedList<LabelValueItem>();
    @SerializedName(value="type")
    private final GraphType graphType;
    private final String percentage;

    public FunnelGraph(String widgetKey, boolean showPercentage) {
        this(widgetKey, GraphType.STANDARD, showPercentage);
    }

    public FunnelGraph(String widgetKey, GraphType graphType, boolean showPercentage) {
        super(widgetKey);
        this.graphType = graphType;
        this.percentage = showPercentage ? "show" : "hide";
    }

    public void addData(String label, String value) {
        this.items.add(new LabelValueItem(label, value));
    }

    @Override
    protected void validate() throws ValidationException {
        if (this.items.size() == 0) {
            throw new ValidationException("item", "Items cannot be empty");
        }
        if (this.graphType == null) {
            throw new ValidationException("graphType", "Cannot be null");
        }
        if (this.percentage == null) {
            throw new ValidationException("percentage", "Cannot be null");
        }
    }
}

