/*
 * Decompiled with CFR 0.152.
 */
package nl.pvanassen.geckoboard.api.widget;

import com.google.gson.annotations.SerializedName;
import java.awt.Color;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import nl.pvanassen.geckoboard.api.Push;
import nl.pvanassen.geckoboard.api.error.ValidationException;
import nl.pvanassen.geckoboard.api.json.linechart.LineChartSettings;

public class LineChart
extends Push {
    @SerializedName(value="item")
    private final List<String> items = new LinkedList<String>();
    private final LineChartSettings settings = new LineChartSettings();

    public LineChart(String widgetKey) {
        super(widgetKey);
    }

    public void addDataPoint(String dataPoint) {
        this.items.add(dataPoint);
    }

    public void setAxisXLabels(Collection<String> labels) {
        this.settings.getAxisx().clear();
        this.settings.getAxisx().addAll(labels);
    }

    public void setAxisYLabels(Collection<String> labels) {
        this.settings.getAxisy().clear();
        this.settings.getAxisy().addAll(labels);
    }

    public void setColor(Color color) {
        this.settings.setColor(color);
    }

    @Override
    protected void validate() throws ValidationException {
        if (this.items.size() == 0) {
            throw new ValidationException("item", "Must be filled");
        }
        if (this.settings.getAxisx().size() == 0) {
            throw new ValidationException("axisx", "Must be filled");
        }
        if (this.settings.getAxisy().size() == 0) {
            throw new ValidationException("axisy", "Must be filled");
        }
    }
}

